/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.util.HashMap;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.Term;
import org.kframework.kil.Token;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.w3c.dom.Element;

public class Int32Builtin
extends Token {
    public static final String SORT_NAME = "#Int32";
    private static Map<Integer, Int32Builtin> tokenCache = new HashMap<Integer, Int32Builtin>();
    private static Map<Integer, KApp> kAppCache = new HashMap<Integer, KApp>();
    public static final Int32Builtin ZERO_TOKEN = Int32Builtin.of(0);
    public static final Int32Builtin ONE_TOKEN = Int32Builtin.of(1);
    public static final KApp ZERO = Int32Builtin.kAppOf(0);
    public static final KApp ONE = Int32Builtin.kAppOf(1);
    private final int value;

    public static Int32Builtin of(int value) {
        Int32Builtin intBuiltin = tokenCache.get(value);
        if (intBuiltin == null) {
            intBuiltin = new Int32Builtin(value);
            tokenCache.put(value, intBuiltin);
        }
        return intBuiltin;
    }

    public static Int32Builtin of(String value) {
        assert (value != null);
        return Int32Builtin.of(new Integer(value));
    }

    public static KApp kAppOf(int value) {
        KApp kApp = kAppCache.get(value);
        if (kApp == null) {
            kApp = KApp.of(Int32Builtin.of(value), new Term[0]);
            kAppCache.put(value, kApp);
        }
        return kApp;
    }

    public static KApp kAppOf(long value) {
        return Int32Builtin.kAppOf((int)value);
    }

    public static KApp kAppOf(String value) {
        assert (value != null);
        return Int32Builtin.kAppOf(new Integer(value));
    }

    private Int32Builtin(int value) {
        this.value = value;
    }

    protected Int32Builtin(Element element) {
        super(element);
        this.value = new Integer(element.getAttribute("value"));
    }

    protected Int32Builtin(ATermAppl atm) {
        super(atm);
        this.value = new Integer(((ATermAppl)atm.getArgument(0)).getName());
    }

    public int intValue() {
        return this.value;
    }

    @Override
    public String tokenSort() {
        return SORT_NAME;
    }

    @Override
    public String value() {
        return Integer.toString(this.value);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

