/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.Term;
import org.kframework.kil.Token;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.w3c.dom.Element;

public class IntBuiltin
extends Token {
    public static final String SORT_NAME = "#Int";
    private static Map<BigInteger, IntBuiltin> tokenCache = new HashMap<BigInteger, IntBuiltin>();
    private static Map<BigInteger, KApp> kAppCache = new HashMap<BigInteger, KApp>();
    public static final IntBuiltin ZERO_TOKEN = IntBuiltin.of(0L);
    public static final IntBuiltin ONE_TOKEN = IntBuiltin.of(1L);
    public static final KApp ZERO = IntBuiltin.kAppOf(0L);
    public static final KApp ONE = IntBuiltin.kAppOf(1L);
    private final BigInteger value;

    public static IntBuiltin of(BigInteger value) {
        assert (value != null);
        IntBuiltin intBuiltin = tokenCache.get(value);
        if (intBuiltin == null) {
            intBuiltin = new IntBuiltin(value);
            tokenCache.put(value, intBuiltin);
        }
        return intBuiltin;
    }

    public static IntBuiltin of(long value) {
        return IntBuiltin.of(BigInteger.valueOf(value));
    }

    public static IntBuiltin of(String value) {
        assert (value != null);
        return IntBuiltin.of(new BigInteger(value));
    }

    public static KApp kAppOf(BigInteger value) {
        assert (value != null);
        KApp kApp = kAppCache.get(value);
        if (kApp == null) {
            kApp = KApp.of(IntBuiltin.of(value), new Term[0]);
            kAppCache.put(value, kApp);
        }
        return kApp;
    }

    public static KApp kAppOf(long value) {
        return IntBuiltin.kAppOf(BigInteger.valueOf(value));
    }

    public static KApp kAppOf(String value) {
        assert (value != null);
        return IntBuiltin.kAppOf(new BigInteger(value));
    }

    private IntBuiltin(BigInteger value) {
        this.value = value;
    }

    protected IntBuiltin(Element element) {
        super(element);
        this.value = new BigInteger(element.getAttribute("value"));
    }

    protected IntBuiltin(ATermAppl atm) {
        super(atm);
        this.value = new BigInteger(((ATermAppl)atm.getArgument(0)).getName());
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    @Override
    public String tokenSort() {
        return SORT_NAME;
    }

    @Override
    public String value() {
        return this.value.toString();
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

