/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.KList;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.xml.XML;
import org.w3c.dom.Element;

public class KApp
extends Term {
    private Term label;
    private Term child;

    public static KApp of(Term label, Term ... elements) {
        return new KApp(label, new KList(Arrays.asList(elements)));
    }

    public KApp(String location, String filename, Term label, Term child) {
        super(location, filename, "KItem");
        this.setLabel(label);
        this.setChild(child);
    }

    public KApp(Term label, Term child) {
        super("KItem");
        this.setLabel(label);
        this.setChild(child);
    }

    public KApp(Element element, Context context) {
        super(element);
        List<Element> childrenElements = XML.getChildrenElements(element);
        Element body = XML.getChildrenElements(childrenElements.get(0)).get(0);
        this.setLabel((Term)JavaClassesFactory.getTerm(body));
        Term term = (Term)JavaClassesFactory.getTerm(childrenElements.get(1));
        if (!term.getSort().equals("KList") && !(term instanceof Ambiguity)) {
            this.setChild(new KList(Collections.singletonList(term)));
        } else {
            this.setChild(term);
        }
    }

    public KApp(ATermAppl atm) {
        super(atm);
        this.sort = "KItem";
        this.label = (Term)JavaClassesFactory.getTerm(atm.getArgument(0));
        this.child = (Term)JavaClassesFactory.getTerm(atm.getArgument(1));
    }

    private KApp(KApp node) {
        super(node);
        this.setLabel(node.label);
        this.setChild(node.child);
    }

    public String toString() {
        return this.label + "(" + this.child + ")";
    }

    public Term getLabel() {
        return this.label;
    }

    public void setLabel(Term label) {
        assert (label != null);
        this.label = label;
    }

    public Term getChild() {
        return this.child;
    }

    public void setChild(Term child) {
        assert (child != null);
        this.child = child;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    @Override
    public KApp shallowCopy() {
        return new KApp(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof KApp)) {
            return false;
        }
        KApp k = (KApp)o;
        return this.label.equals(k.label) && this.child.equals(k.child);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Bracket) {
            return this.contains(((Bracket)o).getContent());
        }
        if (o instanceof Cast) {
            return this.contains(((Cast)o).getContent());
        }
        if (!(o instanceof KApp)) {
            return false;
        }
        KApp k = (KApp)o;
        return this.label.contains(k.label) && this.child.contains(k.child);
    }

    @Override
    public int hashCode() {
        return this.label.hashCode() * 23 + this.child.hashCode();
    }
}

