/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KLabel;
import org.kframework.kil.Production;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;
import org.w3c.dom.Element;

public class KLabelConstant
extends KLabel {
    private static final HashMap<String, KLabelConstant> cache = new HashMap();
    public static final KLabelConstant COOL_KLABEL = KLabelConstant.of("cool");
    public static final KLabelConstant HEAT_KLABEL = KLabelConstant.of("heat");
    public static final KLabelConstant HEATED_KLABEL = KLabelConstant.of("heated");
    public static final KLabelConstant REDEX_KLABEL = KLabelConstant.of("redex");
    public static final KLabelConstant KNEQ_KLABEL = KLabelConstant.of("'_=/=K_");
    public static final KLabelConstant KEQ_KLABEL = KLabelConstant.of("'_==K_");
    public static final KLabelConstant KEQ = KLabelConstant.of("'_=K_");
    public static final KLabelConstant KLIST_EQUALITY = KLabelConstant.of("'_=KList_");
    public static final KLabelConstant ANDBOOL_KLABEL = KLabelConstant.of("'#andBool");
    public static final KLabelConstant BOOL_ANDBOOL_KLABEL = KLabelConstant.of("'_andBool_");
    public static final KLabelConstant NOTBOOL_KLABEL = KLabelConstant.of("'notBool_");
    public static final KLabelConstant BOOL_ANDTHENBOOL_KLABEL = KLabelConstant.of("'_andThenBool_");
    public static final KLabelConstant KRESULT_PREDICATE = KLabelConstant.of(AddPredicates.predicate("KResult"));
    public static final KLabelConstant STREAM_PREDICATE = KLabelConstant.of(AddPredicates.predicate("Stream"));
    public static final KLabelConstant STRING_PLUSSTRING_KLABEL = KLabelConstant.of("'_+String_");
    private final String label;
    private final List<Production> productions;

    public static final KLabelConstant of(String label, Context context) {
        assert (label != null);
        KLabelConstant kLabelConstant = cache.get(label);
        if (kLabelConstant == null) {
            kLabelConstant = new KLabelConstant(label, context);
            cache.put(label, kLabelConstant);
        }
        return kLabelConstant;
    }

    public static KLabelConstant of(String label) {
        assert (label != null);
        KLabelConstant kLabelConstant = cache.get(label);
        if (kLabelConstant == null) {
            kLabelConstant = new KLabelConstant(label);
            cache.put(label, kLabelConstant);
        }
        return kLabelConstant;
    }

    public boolean isPredicate() {
        return this.label.startsWith("is");
    }

    public String getLabel() {
        return this.label;
    }

    public KLabelConstant(String label) {
        this.label = label;
        this.productions = Collections.emptyList();
    }

    private KLabelConstant(String label, Context context) {
        this.label = label;
        this.productions = Collections.unmodifiableList(context.productionsOf(label));
    }

    public KLabelConstant(Element element, Context context) {
        super(element);
        this.label = StringUtil.unescapeMaude(element.getAttribute("value"));
        this.productions = Collections.unmodifiableList(context.productionsOf(this.label));
    }

    public KLabelConstant(Element element) {
        super(element);
        this.label = StringUtil.unescapeMaude(element.getAttribute("value"));
        this.productions = Collections.EMPTY_LIST;
    }

    public KLabelConstant(ATermAppl atm) {
        super(atm);
        this.label = StringUtil.unescapeMaude(((ATermAppl)atm.getArgument(0)).getName());
        this.productions = Collections.EMPTY_LIST;
    }

    public List<Production> productions() {
        return this.productions;
    }

    @Override
    public Term shallowCopy() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KLabelConstant)) {
            return false;
        }
        KLabelConstant kLabelConstant = (KLabelConstant)object;
        return this.label.equals(kLabelConstant.label);
    }

    @Override
    public int hashCode() {
        return this.label.hashCode();
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

