/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Term;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;
import org.w3c.dom.Element;

public class ListTerminator
extends Term {
    private final String separator;

    public ListTerminator(String sort, String separator) {
        super(sort);
        this.separator = separator;
    }

    public ListTerminator(String separator) {
        super("K");
        this.separator = separator;
    }

    private ListTerminator(ListTerminator terminator) {
        super(terminator);
        this.separator = terminator.separator;
    }

    public ListTerminator(Element element, String separator) {
        super(element);
        this.sort = element.getAttribute("sort");
        this.separator = separator;
    }

    public ListTerminator(ATermAppl atm, String separator) {
        super(atm);
        this.sort = StringUtil.getSortNameFromCons(atm.getName());
        this.separator = separator;
    }

    public String toString() {
        if (this.separator != null && this.sort.equals("K")) {
            return ".List{\"" + this.separator + "\"}";
        }
        return "." + this.sort;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    @Override
    public ListTerminator shallowCopy() {
        return new ListTerminator(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ListTerminator)) {
            return false;
        }
        ListTerminator l = (ListTerminator)o;
        return this.sort.equals(l.sort) && (this.separator == null && l.separator == null || this.separator != null && l.separator != null && this.separator.equals(l.separator));
    }

    @Override
    public int hashCode() {
        return (this.sort + this.separator).hashCode();
    }

    public String separator() {
        return this.separator;
    }
}

