/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.DataStructureBuiltin;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.Term;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class MapBuiltin
extends DataStructureBuiltin {
    private final Map<Term, Term> elements;

    public MapBuiltin(DataStructureSort sort, Collection<Term> baseTerms, Map<Term, Term> elements) {
        super(sort, baseTerms);
        this.elements = elements;
    }

    public Map<Term, Term> elements() {
        return Collections.unmodifiableMap(this.elements);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty() && this.baseTerms.isEmpty();
    }

    @Override
    public Term shallowCopy() {
        return new MapBuiltin(this.dataStructureSort, this.baseTerms, this.elements);
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = hash * 37 + super.hashCode();
        hash = hash * 37 + this.elements.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MapBuiltin)) {
            return false;
        }
        MapBuiltin mapBuiltin = (MapBuiltin)object;
        return super.equals(mapBuiltin) && this.elements.equals(mapBuiltin.elements);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

