/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.CollectionItem;
import org.kframework.kil.Term;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.xml.XML;
import org.w3c.dom.Element;

public class MapItem
extends CollectionItem {
    private Term key;

    public MapItem(Element element) {
        super(element);
        Element elm = XML.getChildrenElementsByTagName(element, "key").get(0);
        Element elmBody = XML.getChildrenElements(elm).get(0);
        this.key = (Term)JavaClassesFactory.getTerm(elmBody);
        elm = XML.getChildrenElementsByTagName(element, "value").get(0);
        elmBody = XML.getChildrenElements(elm).get(0);
        this.value = (Term)JavaClassesFactory.getTerm(elmBody);
    }

    public MapItem(ATermAppl atm) {
        super(atm);
        this.key = (Term)JavaClassesFactory.getTerm(atm.getArgument(0));
        this.value = (Term)JavaClassesFactory.getTerm(atm.getArgument(1));
    }

    public MapItem(String location, String filename) {
        super(location, filename, "MapItem");
    }

    public MapItem(MapItem node) {
        super(node);
        this.key = node.key;
    }

    public MapItem() {
        super("MapItem");
    }

    public MapItem(Term key, Term value) {
        this();
        this.key = key;
        this.value = value;
    }

    public void setKey(Term key) {
        this.key = key;
    }

    public Term getKey() {
        return this.key;
    }

    public Term getValue() {
        return this.value;
    }

    public void setValue(Term t) {
        this.value = t;
    }

    public String toString() {
        return this.key + " |-> " + this.value;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    @Override
    public MapItem shallowCopy() {
        return new MapItem(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MapItem)) {
            return false;
        }
        MapItem m = (MapItem)o;
        return this.key.equals(m.key) && this.value.equals(m.value);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Bracket) {
            return this.contains(((Bracket)o).getContent());
        }
        if (o instanceof Cast) {
            return this.contains(((Cast)o).getContent());
        }
        if (!(o instanceof MapItem)) {
            return false;
        }
        MapItem m = (MapItem)o;
        return this.key.contains(m.key) && this.value.contains(m.value);
    }

    @Override
    public int hashCode() {
        return this.key.hashCode() * 31 + this.value.hashCode();
    }
}

