/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.Collections;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class MapUpdate
extends Term {
    private final Variable map;
    private final Map<Term, Term> removeEntries;
    private final Map<Term, Term> updateEntries;

    public MapUpdate(Variable map, Map<Term, Term> removeEntries, Map<Term, Term> updateEntries) {
        super(map.getSort());
        this.map = map;
        this.removeEntries = removeEntries;
        this.updateEntries = updateEntries;
    }

    public Variable map() {
        return this.map;
    }

    public Map<Term, Term> removeEntries() {
        return Collections.unmodifiableMap(this.removeEntries);
    }

    public Map<Term, Term> updateEntries() {
        return Collections.unmodifiableMap(this.updateEntries);
    }

    @Override
    public Term shallowCopy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = hash * 37 + this.map.hashCode();
        hash = hash * 37 + this.removeEntries.hashCode();
        hash = hash * 37 + this.updateEntries.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MapUpdate)) {
            return false;
        }
        MapUpdate mapUpdate = (MapUpdate)object;
        return this.map.equals(mapUpdate.map) && this.removeEntries.equals(mapUpdate.removeEntries) && this.updateEntries.equals(mapUpdate.updateEntries);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

