/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.kframework.kil.ASTNode;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Rule;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Terminal;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class Module
extends DefinitionItem {
    private String name;
    private List<ModuleItem> items = new ArrayList<ModuleItem>();

    public Module(Module m) {
        super(m);
        this.name = m.name;
        this.items = m.items;
    }

    public Module() {
    }

    public Module(String name) {
        this.name = name;
    }

    public void appendModuleItem(ModuleItem item) {
        this.items.add(item);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setItems(List<ModuleItem> items) {
        this.items = items;
    }

    public List<ModuleItem> getItems() {
        return this.items;
    }

    public String toString() {
        String content = "";
        for (ModuleItem i : this.items) {
            content = content + i + " \n";
        }
        return "module " + this.name + "\n" + content + "\nendmodule";
    }

    public List<String> getModuleKLabels() {
        LinkedList<String> mkl = new LinkedList<String>();
        for (ModuleItem mi : this.items) {
            List<String> list = mi.getKLabels();
            if (list == null) continue;
            mkl.addAll(list);
        }
        return mkl;
    }

    public Set<String> getAllSorts() {
        HashSet<String> sorts = new HashSet<String>();
        for (ModuleItem mi : this.items) {
            List<String> list = mi.getAllSorts();
            if (list == null) continue;
            sorts.addAll(list);
        }
        sorts.add("#Bool");
        sorts.add("#Int");
        sorts.add("#Float");
        sorts.add("#String");
        sorts.add("#Id");
        return sorts;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public Module addModuleItems(List<ModuleItem> rules) {
        Module result = new Module(this);
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>(this.items);
        items.addAll(rules);
        result.setItems(items);
        return result;
    }

    @Override
    public Module shallowCopy() {
        return new Module(this);
    }

    public void addSubsort(String sort, String subsort, Context context) {
        this.addProduction(sort, new Sort(subsort));
        context.addSubsort(sort, subsort);
    }

    public void addConstant(String ctSort, String ctName) {
        this.addProduction(ctSort, new Terminal(ctName));
    }

    public void addConstant(KLabelConstant kLabelConstant) {
        this.addProduction(kLabelConstant.getSort(), new Terminal(kLabelConstant.getLabel()));
    }

    public void addProduction(String sort, ProductionItem prodItem) {
        LinkedList<ProductionItem> prodItems = new LinkedList<ProductionItem>();
        prodItems.add(prodItem);
        this.addProduction(sort, new Production(new Sort(sort), prodItems));
    }

    public void addProduction(String sort, Production prod) {
        LinkedList<PriorityBlock> pbs = new LinkedList<PriorityBlock>();
        PriorityBlock pb = new PriorityBlock();
        pbs.add(pb);
        LinkedList<Production> prods = new LinkedList<Production>();
        pb.setProductions(prods);
        prods.add(prod);
        this.items.add(new Syntax(new Sort(sort), pbs));
    }

    public List<Rule> getRules() {
        LinkedList<Rule> list = new LinkedList<Rule>();
        for (ModuleItem moduleItem : this.items) {
            if (!(moduleItem instanceof Rule)) continue;
            list.add((Rule)moduleItem);
        }
        return list;
    }

    public Collection<Production> getProductionsOf(String sort) {
        ArrayList<Production> productions = new ArrayList<Production>();
        for (ModuleItem item : this.items) {
            Syntax syntax;
            if (!(item instanceof Syntax) || !(syntax = (Syntax)item).getSort().getName().equals(sort)) continue;
            for (PriorityBlock priorityBlock : syntax.getPriorityBlocks()) {
                productions.addAll(priorityBlock.getProductions());
            }
        }
        return productions;
    }
}

