/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Production;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class PriorityBlock
extends ASTNode {
    List<Production> productions = new ArrayList<Production>();
    String assoc;

    public List<Production> getProductions() {
        return this.productions;
    }

    public void setProductions(List<Production> productions) {
        this.productions = productions;
    }

    public String getAssoc() {
        return this.assoc;
    }

    public void setAssoc(String assoc) {
        this.assoc = assoc;
    }

    public PriorityBlock() {
        this.assoc = "";
    }

    public PriorityBlock(String assoc, List<Production> productions) {
        this.assoc = assoc;
        this.productions = productions;
    }

    public PriorityBlock(PriorityBlock node) {
        super(node);
        this.assoc = node.assoc;
        this.productions.addAll(node.productions);
    }

    public String toString() {
        String content = "";
        for (Production production : this.productions) {
            content = content + production + "\n| ";
        }
        if (content.length() > 2) {
            content = content.substring(0, content.length() - 3);
        }
        if (this.assoc == null || this.assoc.equals("")) {
            return content;
        }
        return this.assoc + ": " + content;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PriorityBlock)) {
            return false;
        }
        PriorityBlock pb = (PriorityBlock)obj;
        if (!pb.getAssoc().equals(this.assoc)) {
            return false;
        }
        if (pb.productions.size() != this.productions.size()) {
            return false;
        }
        for (int i = 0; i < pb.productions.size(); ++i) {
            if (pb.productions.get(i).equals(this.productions.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.assoc.hashCode();
        for (Production prd : this.productions) {
            hash += prd.hashCode();
        }
        return hash;
    }

    @Override
    public PriorityBlock shallowCopy() {
        return new PriorityBlock(this);
    }
}

