/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.PriorityBlockExtended;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class PriorityExtended
extends ModuleItem {
    List<PriorityBlockExtended> priorityBlocks;

    public PriorityExtended(List<PriorityBlockExtended> priorities) {
        this.priorityBlocks = priorities;
    }

    public List<PriorityBlockExtended> getPriorityBlocks() {
        return this.priorityBlocks;
    }

    public void setPriorityBlocks(List<PriorityBlockExtended> priorityBlocks) {
        this.priorityBlocks = priorityBlocks;
    }

    public PriorityExtended(PriorityExtended node) {
        super(node);
        this.priorityBlocks = node.priorityBlocks;
    }

    public String toString() {
        String blocks = "";
        for (PriorityBlockExtended pb : this.priorityBlocks) {
            blocks = blocks + pb + "\n> ";
        }
        if (blocks.length() > 2) {
            blocks = blocks.substring(0, blocks.length() - 3);
        }
        return "  syntax priorities" + blocks + "\n";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PriorityExtended)) {
            return false;
        }
        PriorityExtended syn = (PriorityExtended)obj;
        if (syn.priorityBlocks.size() != this.priorityBlocks.size()) {
            return false;
        }
        for (int i = 0; i < syn.priorityBlocks.size(); ++i) {
            if (syn.priorityBlocks.get(i).equals(this.priorityBlocks.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (PriorityBlockExtended pb : this.priorityBlocks) {
            hash += pb.hashCode();
        }
        return hash;
    }

    @Override
    public PriorityExtended shallowCopy() {
        return new PriorityExtended(this);
    }
}

