/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.Lexical;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class Production
extends ASTNode {
    protected List<ProductionItem> items;
    protected String sort;
    protected String ownerModuleName;
    private Multimap<Integer, Integer> binderMap;

    public static Production makeFunction(String funSort, String funName, String argSort, Context context) {
        ArrayList<ProductionItem> prodItems = new ArrayList<ProductionItem>();
        prodItems.add(new Terminal(funName));
        prodItems.add(new Terminal("("));
        prodItems.add(new Sort(argSort));
        prodItems.add(new Terminal(")"));
        Production funProd = new Production(new Sort(funSort), prodItems);
        funProd.addAttribute(new Attribute("prefixlabel", funName));
        if (MetaK.isComputationSort(funSort)) {
            funProd.addAttribute(new Attribute("klabel", funName));
            String consAttr = funSort + "1" + funName + "Syn";
            funProd.addAttribute(new Attribute("cons", consAttr));
            context.conses.put(consAttr, funProd);
            context.putLabel(funProd, consAttr);
        }
        return funProd;
    }

    public boolean isListDecl() {
        return this.items.size() == 1 && this.items.get(0) instanceof UserList;
    }

    public boolean isSubsort() {
        return this.items.size() == 1 && this.items.get(0) instanceof Sort;
    }

    public boolean isLexical() {
        return this.items.size() == 1 && this.items.get(0) instanceof Lexical;
    }

    public boolean isConstant() {
        return this.items.size() == 1 && this.items.get(0) instanceof Terminal && (this.sort.startsWith("#") || this.sort.equals("KLabel"));
    }

    public Production(Production node) {
        super(node);
        this.items = node.items;
        this.sort = node.sort;
        this.ownerModuleName = node.ownerModuleName;
    }

    public Production(Sort sort, List<ProductionItem> items) {
        this.items = items;
        this.sort = sort.getName();
        this.attributes = new Attributes();
    }

    public Production(Sort sort, List<ProductionItem> items, String ownerModule) {
        this.items = items;
        this.sort = sort.getName();
        this.attributes = new Attributes();
        this.ownerModuleName = ownerModule;
    }

    public String getCons() {
        return this.attributes.get("cons");
    }

    public String getLabel() {
        String label = this.attributes.get("prefixlabel");
        if (label == null) {
            label = this.getPrefixLabel();
            this.attributes.set("prefixlabel", label);
        }
        return label.replace(" ", "");
    }

    public String getKLabel() {
        String klabel = this.attributes.get("klabel");
        if (klabel == null) {
            klabel = this.sort.toString().equals("KLabel") ? this.getPrefixLabel() : "'" + this.getPrefixLabel();
            this.attributes.set("klabel", klabel);
        }
        return klabel.replace(" ", "");
    }

    private String getPrefixLabel() {
        String label = "";
        for (ProductionItem pi : this.items) {
            if (pi instanceof Sort) {
                label = label + "_";
                continue;
            }
            if (pi instanceof Terminal) {
                label = label + ((Terminal)pi).getTerminal();
                continue;
            }
            if (!(pi instanceof UserList)) continue;
            label = label + "_" + ((UserList)pi).separator + "_";
        }
        return label;
    }

    public List<ProductionItem> getItems() {
        return this.items;
    }

    public void setItems(List<ProductionItem> items) {
        this.items = items;
    }

    public int getArity() {
        int arity = 0;
        for (ProductionItem i : this.items) {
            if (i instanceof UserList) {
                arity += 2;
            }
            if (!(i instanceof Sort)) continue;
            ++arity;
        }
        return arity;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getChildSort(int idx) {
        int arity = -1;
        if (this.items.get(0) instanceof UserList) {
            if (idx == 0) {
                return ((UserList)this.items.get(0)).getSort();
            }
            return this.getSort();
        }
        for (ProductionItem i : this.items) {
            if (!(i instanceof Terminal)) {
                ++arity;
            }
            if (arity != idx) continue;
            return ((Sort)i).getName();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Production)) {
            return false;
        }
        Production prd = (Production)obj;
        if (this.sort != null && prd.getSort() != null && !this.sort.equals(prd.getSort())) {
            return false;
        }
        if (this.sort == null && prd.getSort() != null) {
            return false;
        }
        if (prd.getItems().size() != this.items.size()) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (prd.getItems().get(i).equals(this.items.get(i))) continue;
            return false;
        }
        String klabel1 = prd.getAttributes().get("klabel");
        String klabel2 = this.getAttributes().get("klabel");
        if (klabel1 == null && klabel2 != null || klabel1 != null && klabel2 == null) {
            return false;
        }
        return klabel1 == null || klabel2 == null || !klabel1.equals(klabel2);
    }

    public int hashCode() {
        int hash = 0;
        if (this.sort != null) {
            hash += this.sort.hashCode();
        }
        for (ProductionItem pi : this.items) {
            hash += pi.hashCode();
        }
        return hash;
    }

    public String toString() {
        String content = "";
        for (ProductionItem i : this.items) {
            content = content + i + " ";
        }
        return content;
    }

    @Override
    public Production shallowCopy() {
        return new Production(this);
    }

    public String getOwnerModuleName() {
        return this.ownerModuleName;
    }

    public void setOwnerModuleName(String ownerModuleName) {
        this.ownerModuleName = ownerModuleName;
    }

    public boolean hasTerminalToRight(int idx) {
        int arity = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            ProductionItem item = this.items.get(i);
            if (item instanceof UserList) {
                if (idx == arity) {
                    return !((UserList)item).getSeparator().equals("");
                }
                if (idx == arity + 1) {
                    return false;
                }
                arity += 2;
                continue;
            }
            if (!(item instanceof Sort)) continue;
            if (idx == arity) {
                return i != this.items.size() - 1 && this.items.get(i + 1) instanceof Terminal;
            }
            ++arity;
        }
        throw new IllegalArgumentException("Index not found in production");
    }

    public boolean hasTerminalToLeft(int idx) {
        int arity = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            ProductionItem item = this.items.get(i);
            if (item instanceof UserList) {
                if (idx == arity) {
                    return false;
                }
                if (idx == arity + 1) {
                    return !((UserList)item).getSeparator().equals("");
                }
                arity += 2;
                continue;
            }
            if (!(item instanceof Sort)) continue;
            if (idx == arity) {
                return i != 0 && this.items.get(i - 1) instanceof Terminal;
            }
            ++arity;
        }
        throw new IllegalArgumentException("Index not found in production");
    }

    public Multimap<Integer, Integer> getBinderMap() {
        return this.binderMap;
    }

    public void setBinderMap(Multimap<Integer, Integer> binderMap) {
        this.binderMap = binderMap;
    }
}

