/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import org.kframework.kil.ASTNode;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Terminal;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class Restrictions
extends ModuleItem {
    Sort sort;
    Terminal terminal;
    String pattern;

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public Restrictions(Sort sort, Terminal terminal, String pattern) {
        this.sort = sort;
        this.terminal = terminal;
        this.pattern = pattern;
    }

    public Restrictions(Restrictions node) {
        super(node);
        this.sort = node.sort;
        this.terminal = node.terminal;
        this.pattern = node.pattern;
    }

    public String toString() {
        return "  syntax " + (this.sort != null ? this.sort : this.terminal) + " -/- " + this.pattern + "\n";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Restrictions)) {
            return false;
        }
        Restrictions syn = (Restrictions)obj;
        if (!this.pattern.equals(syn.pattern)) {
            return false;
        }
        return this.sort == null ? this.terminal.equals(syn.terminal) : this.sort.equals(syn.sort);
    }

    public int hashCode() {
        int hash = this.pattern.hashCode();
        return hash += this.sort != null ? this.sort.hashCode() : this.terminal.hashCode();
    }

    @Override
    public Restrictions shallowCopy() {
        return new Restrictions(this);
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

