/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import com.google.common.collect.ImmutableSet;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;
import org.kframework.utils.xml.XML;
import org.w3c.dom.Element;

public class Rewrite
extends Term {
    private Term left;
    private Term right;

    public Rewrite(Element element) {
        super(element);
        Element temp = XML.getChildrenElementsByTagName(element, "left").get(0);
        temp = XML.getChildrenElements(temp).get(0);
        this.left = (Term)JavaClassesFactory.getTerm(temp);
        temp = XML.getChildrenElementsByTagName(element, "right").get(0);
        temp = XML.getChildrenElements(temp).get(0);
        this.right = (Term)JavaClassesFactory.getTerm(temp);
    }

    public Rewrite(ATermAppl atm) {
        super(atm);
        this.sort = StringUtil.getSortNameFromCons(atm.getName());
        this.left = (Term)JavaClassesFactory.getTerm(atm.getArgument(0));
        this.right = (Term)JavaClassesFactory.getTerm(atm.getArgument(1));
    }

    public Rewrite(Rewrite node) {
        super(node);
        this.left = node.left;
        this.right = node.right;
    }

    public Rewrite(Term eval1Left, Term eval1Right, Context context) {
        super(eval1Left.getSort());
        this.left = eval1Left;
        this.right = eval1Right;
        this.recomputeSort(context);
    }

    private void recomputeSort(Context context) {
        if (this.left instanceof Ambiguity || this.right instanceof Ambiguity) {
            super.getSort();
        } else {
            this.sort = context.getLUBSort(ImmutableSet.of(this.left.getSort(), this.right.getSort()));
        }
    }

    public Term getLeft() {
        return this.left;
    }

    public Term getRight() {
        return this.right;
    }

    public void replaceChildren(Term left, Term right, Context context) {
        this.left = left;
        this.right = right;
        this.recomputeSort(context);
    }

    public void setLeft(Term left, Context context) {
        this.left = left;
        this.recomputeSort(context);
    }

    public void setRight(Term right, Context context) {
        this.right = right;
        this.recomputeSort(context);
    }

    public String toString() {
        return this.left + " => " + this.right;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    @Override
    public Rewrite shallowCopy() {
        return new Rewrite(this);
    }

    @Override
    public int hashCode() {
        return 59 * this.left.hashCode() + this.right.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rewrite)) {
            return false;
        }
        Rewrite r = (Rewrite)o;
        return this.left.equals(r.left) && this.right.equals(r.right);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Bracket) {
            return this.contains(((Bracket)o).getContent());
        }
        if (o instanceof Cast) {
            return this.contains(((Cast)o).getContent());
        }
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rewrite)) {
            return false;
        }
        Rewrite r = (Rewrite)o;
        return this.left.contains(r.left) && this.right.contains(r.right);
    }
}

