/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.BuiltinLookup;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.w3c.dom.Element;

public class Rule
extends Sentence {
    private List<BuiltinLookup> lookups = Collections.emptyList();
    private Map<Variable, Integer> concreteDataStructureSize = Collections.emptyMap();

    public Rule(Element element) {
        super(element);
    }

    public Rule(Rule node) {
        super(node);
        this.lookups = node.lookups;
        this.concreteDataStructureSize = node.concreteDataStructureSize;
    }

    public Rule() {
    }

    public Rule(Term lhs, Term rhs, Context context) {
        this.setBody(new Rewrite(lhs, rhs, context));
    }

    public Rule(Term lhs, Term rhs, Term requires, Term ensures, Context context) {
        this(lhs, rhs, context);
        this.setRequires(requires);
        this.setEnsures(ensures);
    }

    public Rule(Sentence term) {
        super(term);
    }

    @Override
    public String toString() {
        String content = "  rule ";
        if (this.label != null && !this.label.equals("")) {
            content = content + "[" + this.label + "]: ";
        }
        content = content + this.body + " ";
        if (this.requires != null) {
            content = content + "requires " + this.requires + " ";
        }
        if (this.ensures != null) {
            content = content + "ensures " + this.ensures + " ";
        }
        return content + this.attributes;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public Rule shallowCopy() {
        return new Rule(this);
    }

    public List<BuiltinLookup> getLookups() {
        return this.lookups;
    }

    public void setLookups(List<BuiltinLookup> lookups) {
        this.lookups = lookups;
    }

    public Map<Variable, Integer> getConcreteDataStructureSize() {
        return this.concreteDataStructureSize;
    }

    public void setConcreteDataStructureSize(Map<Variable, Integer> concreteDataStructureSize) {
        this.concreteDataStructureSize = concreteDataStructureSize;
    }
}

