/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attributes;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Term;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.xml.XML;
import org.w3c.dom.Element;

public class Sentence
extends ModuleItem {
    String label = "";
    Term body;
    Term requires = null;
    Term ensures = null;

    public Sentence(Sentence s) {
        super(s);
        this.body = s.body;
        this.label = s.label;
        this.requires = s.requires;
        this.ensures = s.ensures;
    }

    public Sentence() {
        this.attributes = new Attributes();
    }

    public Sentence(ATermAppl atm) {
        this.setLocation(atm);
        if (atm.getName().equals("Ensures")) {
            this.ensures = (Term)JavaClassesFactory.getTerm(atm.getArgument(1));
        }
        atm = (ATermAppl)atm.getArgument(0);
        this.body = (Term)JavaClassesFactory.getTerm(atm.getArgument(0));
        if (atm.getName().equals("RequiresSentence")) {
            this.requires = (Term)JavaClassesFactory.getTerm(atm.getArgument(1));
        }
    }

    public Sentence(Element element) {
        this.setLocation(element);
        this.label = element.getAttribute("label");
        Element elm = XML.getChildrenElementsByTagName(element, "body").get(0);
        Element elmBody = XML.getChildrenElements(elm).get(0);
        this.body = (Term)JavaClassesFactory.getTerm(elmBody);
        List<Element> its = XML.getChildrenElementsByTagName(element, "cond");
        if (its.size() > 0) {
            this.requires = (Term)JavaClassesFactory.getTerm(XML.getChildrenElements(its.get(0)).get(0));
        }
        if ((its = XML.getChildrenElementsByTagName(element, "ensures")).size() > 0) {
            this.ensures = (Term)JavaClassesFactory.getTerm(XML.getChildrenElements(its.get(0)).get(0));
        }
        if ((its = XML.getChildrenElementsByTagName(element, "attributes")).size() > 0) {
            this.attributes.setAll((Attributes)JavaClassesFactory.getTerm(its.get(0)));
        } else {
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            this.attributes.addAttribute("generated", "generated");
        }
    }

    public Term getBody() {
        return this.body;
    }

    public void setBody(Term body) {
        this.body = body;
    }

    public Term getRequires() {
        return this.requires;
    }

    public void setRequires(Term requires) {
        this.requires = requires;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public Sentence shallowCopy() {
        return new Sentence(this);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        String content = "";
        if (this.label != null && !this.label.equals("")) {
            content = content + "[" + this.label + "]: ";
        }
        content = content + this.body + " ";
        if (this.requires != null) {
            content = content + "requires " + this.requires + " ";
        }
        if (this.ensures != null) {
            content = content + "ensures " + this.ensures + " ";
        }
        return content + this.attributes;
    }

    public Term getEnsures() {
        return this.ensures;
    }

    public void setEnsures(Term ensures) {
        this.ensures = ensures;
    }
}

