/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.HashSet;
import java.util.Set;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KSort;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class Sort
extends ProductionItem {
    public static final String BOOL = "Bool";
    private String name;
    private static Set<String> baseSorts = new HashSet<String>();

    public Sort(String name) {
        this.name = name;
    }

    public Sort(Sort sort) {
        super(sort);
        this.name = sort.getName();
    }

    public static boolean isBasesort(String sort) {
        return baseSorts.contains(sort);
    }

    public static Set<String> getBaseSorts() {
        return new HashSet<String>(baseSorts);
    }

    public boolean isBaseSort() {
        return Sort.isBasesort(this.getName());
    }

    public void setName(String sort) {
        this.name = sort;
    }

    public String getName() {
        if (MetaK.isCellSort(this.name)) {
            return KSort.Bag.name();
        }
        return this.name;
    }

    public String getRealName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort srt = (Sort)obj;
        return this.getName().equals(srt.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public Sort shallowCopy() {
        return new Sort(this);
    }

    static {
        baseSorts.add("K");
        baseSorts.add("KResult");
        baseSorts.add("KItem");
        baseSorts.add("KList");
        baseSorts.add("Map");
        baseSorts.add("MapItem");
        baseSorts.add("List");
        baseSorts.add("ListItem");
        baseSorts.add("Set");
        baseSorts.add("SetItem");
        baseSorts.add("Bag");
        baseSorts.add("BagItem");
        baseSorts.add("KLabel");
        baseSorts.add("CellLabel");
    }
}

