/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.util.HashMap;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.Term;
import org.kframework.kil.Token;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;
import org.w3c.dom.Element;

public class StringBuiltin
extends Token {
    public static final String SORT_NAME = "#String";
    private static Map<String, StringBuiltin> tokenCache = new HashMap<String, StringBuiltin>();
    private static Map<String, KApp> kAppCache = new HashMap<String, KApp>();
    public static final KApp SPACE = StringBuiltin.kAppOf(" ");
    public static final KApp EMPTY = StringBuiltin.kAppOf("");
    private final String value;
    private final String encodingErrorMsg = "The Unicode standard forbids the encoding of surrogate pair code points. If you need to perform operations on incorrectly-encoded strings, you must represent them as an array of code units.";

    public static StringBuiltin of(String value) {
        StringBuiltin stringBuiltin = tokenCache.get(value);
        if (stringBuiltin == null) {
            stringBuiltin = new StringBuiltin(value);
            tokenCache.put(value, stringBuiltin);
        }
        return stringBuiltin;
    }

    public static KApp kAppOf(String value) {
        KApp kApp = kAppCache.get(value);
        if (kApp == null) {
            kApp = KApp.of(StringBuiltin.of(value), new Term[0]);
            kAppCache.put(value, kApp);
        }
        return kApp;
    }

    public static StringBuiltin valueOf(String value) {
        assert (value.charAt(0) == '\"');
        assert (value.charAt(value.length() - 1) == '\"');
        String stringValue = StringUtil.unescapeK(value);
        return StringBuiltin.of(stringValue);
    }

    private StringBuiltin(String value) {
        this.value = value;
    }

    protected StringBuiltin(Element element) {
        super(element);
        String s = element.getAttribute("value");
        try {
            this.value = StringUtil.unescapeK(s);
        }
        catch (IllegalArgumentException e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "The Unicode standard forbids the encoding of surrogate pair code points. If you need to perform operations on incorrectly-encoded strings, you must represent them as an array of code units.", this.getLocation(), this.getFilename()));
            throw e;
        }
    }

    protected StringBuiltin(ATermAppl atm) {
        super(atm);
        String s = ((ATermAppl)atm.getArgument(0)).getName();
        try {
            this.value = StringUtil.unescapeK(s);
        }
        catch (IllegalArgumentException e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "The Unicode standard forbids the encoding of surrogate pair code points. If you need to perform operations on incorrectly-encoded strings, you must represent them as an array of code units.", this.getLocation(), this.getFilename()));
            throw e;
        }
    }

    public String stringValue() {
        return this.value;
    }

    @Override
    public String tokenSort() {
        return SORT_NAME;
    }

    @Override
    public String value() {
        return StringUtil.escapeK(this.value);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

