/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.Production;
import org.kframework.kil.Sort;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class Syntax
extends ModuleItem {
    Sort sort;
    List<PriorityBlock> priorityBlocks;

    public Syntax(Sort sort, List<PriorityBlock> priorities) {
        this.sort = sort;
        this.priorityBlocks = priorities;
    }

    public Syntax(Sort sort) {
        this(sort, new ArrayList<PriorityBlock>());
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public List<PriorityBlock> getPriorityBlocks() {
        return this.priorityBlocks;
    }

    public void setPriorityBlocks(List<PriorityBlock> priorityBlocks) {
        this.priorityBlocks = priorityBlocks;
    }

    public Syntax(Syntax node) {
        super(node);
        this.sort = node.sort;
        this.priorityBlocks = node.priorityBlocks;
    }

    public String toString() {
        String blocks = "";
        for (PriorityBlock pb : this.priorityBlocks) {
            blocks = blocks + pb + "\n> ";
        }
        if (blocks.length() > 2) {
            blocks = blocks.substring(0, blocks.length() - 3);
        }
        return "  syntax " + this.sort + " ::= " + blocks + "\n";
    }

    @Override
    public List<String> getLabels() {
        LinkedList<String> lbls = new LinkedList<String>();
        for (PriorityBlock pb : this.priorityBlocks) {
            for (Production prod : pb.getProductions()) {
                lbls.add(prod.getLabel());
            }
        }
        return lbls;
    }

    @Override
    public List<String> getKLabels() {
        LinkedList<String> lbls = new LinkedList<String>();
        if (this.priorityBlocks == null) {
            return lbls;
        }
        for (PriorityBlock pb : this.priorityBlocks) {
            for (Production prod : pb.getProductions()) {
                if (!MetaK.isComputationSort(prod.getSort()) && (!prod.getSort().equals("KLabel") || !prod.isConstant())) continue;
                lbls.add(prod.getKLabel());
            }
        }
        return lbls;
    }

    @Override
    public List<String> getAllSorts() {
        ArrayList<String> sorts = new ArrayList<String>();
        sorts.add(this.sort.toString());
        return sorts;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Syntax)) {
            return false;
        }
        Syntax syn = (Syntax)obj;
        if (!syn.getSort().equals(this.sort)) {
            return false;
        }
        if (syn.priorityBlocks.size() != this.priorityBlocks.size()) {
            return false;
        }
        for (int i = 0; i < syn.priorityBlocks.size(); ++i) {
            if (syn.priorityBlocks.get(i).equals(this.priorityBlocks.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.sort.hashCode();
        for (PriorityBlock pb : this.priorityBlocks) {
            hash += pb.hashCode();
        }
        return hash;
    }

    @Override
    public Syntax shallowCopy() {
        return new Syntax(this);
    }
}

