/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Set;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Variable;
import org.kframework.kil.matchers.Matchable;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.StringUtil;
import org.w3c.dom.Element;

public abstract class Term
extends ASTNode
implements Matchable,
Comparable<Term> {
    protected String sort;

    protected Term() {
    }

    public Term(Term t) {
        super(t);
        this.sort = t.sort;
    }

    public Term(String location, String filename, String sort) {
        super(location, filename);
        this.setSort(sort);
    }

    public Term(Element element) {
        super(element);
        this.sort = element.getAttribute("sort");
    }

    public Term(ATermAppl atm) {
        super(atm);
        this.sort = StringUtil.getSortNameFromCons(atm.getName());
    }

    public Term(String sort) {
        this.sort = sort;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    @Override
    public abstract Term shallowCopy();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public boolean contains(Object obj) {
        return this.equals(obj);
    }

    public Set<Variable> variables() {
        final HashSet<Variable> result = new HashSet<Variable>();
        this.accept(new BasicVisitor(null){

            @Override
            public void visit(Variable node) {
                result.add(node);
            }
        });
        return result;
    }

    @Override
    public int compareTo(Term o) {
        return this.toString().compareTo(o.toString());
    }
}

