/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Term;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;
import org.kframework.utils.xml.XML;
import org.w3c.dom.Element;

public class TermCons
extends Term {
    protected final String cons;
    protected List<Term> contents;
    protected Production production;

    public TermCons(Element element, Context context) {
        super(element);
        this.sort = element.getAttribute("sort");
        this.cons = element.getAttribute("cons");
        this.production = (Production)context.conses.get(this.cons);
        assert (this.production != null);
        this.contents = new ArrayList<Term>();
        List<Element> children = XML.getChildrenElements(element);
        for (Element e : children) {
            this.contents.add((Term)JavaClassesFactory.getTerm(e));
        }
    }

    public TermCons(ATermAppl atm, Context context) {
        super(atm);
        this.cons = atm.getName();
        this.sort = StringUtil.getSortNameFromCons(this.cons);
        this.production = (Production)context.conses.get(this.cons);
        assert (this.production != null);
        this.contents = new ArrayList<Term>();
        if (atm.getArity() == 0) {
            this.contents = new ArrayList<Term>();
        } else if (atm.getArgument(0) instanceof ATermList) {
            ATermList list = (ATermList)atm.getArgument(0);
            while (!list.isEmpty()) {
                if (!this.isColon(list.getFirst())) {
                    this.contents.add((Term)JavaClassesFactory.getTerm(list.getFirst()));
                }
                list = list.getNext();
            }
            this.contents.add(new ListTerminator(this.sort, null));
        } else {
            for (int i = 0; i < atm.getArity(); ++i) {
                if (this.isColon(atm.getArgument(i))) continue;
                this.contents.add((Term)JavaClassesFactory.getTerm(atm.getArgument(i)));
            }
        }
    }

    private boolean isColon(ATerm atm) {
        return atm.getType() == 1 && (((ATermAppl)atm).getName().equals("Colon") || ((ATermAppl)atm).getName().equals("QuestionMark"));
    }

    public TermCons(String sort, String cons, Context context) {
        this(sort, cons, new ArrayList<Term>(), context);
    }

    public TermCons(TermCons node) {
        super(node);
        this.cons = node.cons;
        this.contents = new ArrayList<Term>(node.contents);
        this.production = node.production;
        assert (this.production != null);
    }

    public TermCons(String psort, String listCons, List<Term> genContents, Context context) {
        super(psort);
        this.cons = listCons;
        this.contents = genContents;
        this.production = (Production)context.conses.get(this.cons);
    }

    public Production getProduction() {
        return this.production;
    }

    public String toString() {
        String str = "";
        if (this.production.items.size() > 0) {
            if (this.production.items.get(0) instanceof UserList) {
                String separator = ((UserList)this.production.items.get((int)0)).separator;
                str = this.contents.get(0) + " " + separator + " " + this.contents.get(1) + " ";
            } else {
                int j = 0;
                for (int i = 0; i < this.production.items.size(); ++i) {
                    ProductionItem pi = this.production.items.get(i);
                    if (pi instanceof Terminal) {
                        String terminall = pi.toString();
                        terminall = terminall.substring(1, terminall.length() - 1);
                        str = str + terminall + " ";
                        continue;
                    }
                    if (!(pi instanceof Sort)) continue;
                    str = str + this.contents.get(j++) + " ";
                }
            }
        }
        return str;
    }

    @Override
    public String getSort() {
        return this.sort;
    }

    @Override
    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getCons() {
        return this.cons;
    }

    public List<Term> getContents() {
        return this.contents;
    }

    public void setContents(List<Term> contents) {
        this.contents = contents;
    }

    public Term getSubterm(int idx) {
        return this.contents.get(idx);
    }

    public Term setSubterm(int idx, Term term) {
        return this.contents.set(idx, term);
    }

    public int arity() {
        return this.production.getArity();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TermCons)) {
            return false;
        }
        TermCons tc = (TermCons)obj;
        if (!tc.getSort().equals(this.sort)) {
            return false;
        }
        if (!tc.cons.equals(this.cons)) {
            return false;
        }
        if (tc.contents.size() != this.contents.size()) {
            return false;
        }
        for (int i = 0; i < tc.contents.size(); ++i) {
            if (tc.contents.get(i).equals(this.contents.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Bracket) {
            return this.contains(((Bracket)obj).getContent());
        }
        if (obj instanceof Cast) {
            return this.contains(((Cast)obj).getContent());
        }
        if (!(obj instanceof TermCons)) {
            return false;
        }
        TermCons tc = (TermCons)obj;
        if (!tc.getSort().equals(this.sort)) {
            return false;
        }
        if (!tc.cons.equals(this.cons)) {
            return false;
        }
        if (tc.contents.size() != this.contents.size()) {
            return false;
        }
        for (int i = 0; i < tc.contents.size(); ++i) {
            if (this.contents.get(i).contains(tc.contents.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = this.sort.hashCode() + this.cons.hashCode();
        for (Term t : this.contents) {
            hash += t.hashCode();
        }
        return hash;
    }

    @Override
    public TermCons shallowCopy() {
        return new TermCons(this);
    }
}

