/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import org.kframework.kil.ASTNode;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.GenericToken;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabel;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;
import org.w3c.dom.Element;

public abstract class Token
extends KLabel {
    public static Token of(String sort, String value) {
        if (sort.equals("#Bool")) {
            return BoolBuiltin.of(value);
        }
        if (sort.equals("#Int")) {
            return IntBuiltin.of(value);
        }
        if (sort.equals("#String")) {
            return StringBuiltin.of(value);
        }
        return GenericToken.of(sort, value);
    }

    public static KApp kAppOf(String sort, String value) {
        if (sort.equals("#Bool")) {
            return BoolBuiltin.kAppOf(value);
        }
        if (sort.equals("#Int")) {
            return IntBuiltin.kAppOf(value);
        }
        if (sort.equals("#String")) {
            return StringBuiltin.kAppOf(value);
        }
        return GenericToken.kAppOf(sort, value);
    }

    public static KApp kAppOf(Element element) {
        String sort = element.getAttribute("sort");
        if (sort.equals("#Bool")) {
            return KApp.of(new BoolBuiltin(element), new Term[0]);
        }
        if (sort.equals("#Int")) {
            return KApp.of(new IntBuiltin(element), new Term[0]);
        }
        if (sort.equals("#String")) {
            return KApp.of(new StringBuiltin(element), new Term[0]);
        }
        return KApp.of(new GenericToken(element), new Term[0]);
    }

    public static KApp kAppOf(ATermAppl atm) {
        String sort = StringUtil.getSortNameFromCons(atm.getName());
        if (sort.equals("#Bool")) {
            return KApp.of(new BoolBuiltin(atm), new Term[0]);
        }
        if (sort.equals("#Int")) {
            return KApp.of(new IntBuiltin(atm), new Term[0]);
        }
        if (sort.equals("#String")) {
            return KApp.of(new StringBuiltin(atm), new Term[0]);
        }
        return KApp.of(new GenericToken(atm), new Term[0]);
    }

    protected Token() {
    }

    protected Token(Element element) {
        super(element);
    }

    protected Token(ATermAppl element) {
        super(element);
    }

    public abstract String tokenSort();

    public abstract String value();

    @Override
    public Term shallowCopy() {
        return this;
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = hash * 37 + this.tokenSort().hashCode();
        hash = hash * 37 + this.value().hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Token)) {
            return false;
        }
        Token token = (Token)object;
        return this.tokenSort().equals(token.tokenSort()) && this.value().equals(token.value());
    }

    public String toString() {
        return "#token(\"" + this.tokenSort() + "\", " + StringUtil.escapeK(this.value()) + ")";
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

