/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import org.kframework.kil.ASTNode;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class UserList
extends ProductionItem {
    protected String sort;
    protected String separator;
    protected String listType;

    public UserList(String sort, String separator) {
        this.sort = sort;
        this.separator = separator.trim();
        this.listType = "*";
    }

    public UserList(String sort, String separator, String listType) {
        this.sort = sort;
        this.separator = separator.trim();
        this.listType = listType;
    }

    public UserList(UserList userList) {
        super(userList);
        this.sort = userList.sort;
        this.separator = userList.separator.trim();
        this.listType = userList.listType;
    }

    public String toString() {
        if (this.listType.equals("*")) {
            return "List{" + this.sort + ",\"" + this.separator + "\"} ";
        }
        return "NeList{" + this.sort + ",\"" + this.separator + "\"} ";
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator.trim();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UserList)) {
            return false;
        }
        UserList srt = (UserList)obj;
        if (!this.sort.equals(srt.getSort())) {
            return false;
        }
        return this.separator.equals(srt.getSeparator());
    }

    public int hashCode() {
        return this.separator.hashCode() + this.sort.hashCode();
    }

    @Override
    public UserList shallowCopy() {
        return new UserList(this);
    }

    public String getListType() {
        return this.listType;
    }

    public void setListType(String listType) {
        this.listType = listType;
    }
}

