/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Term;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;
import org.w3c.dom.Element;

public class Variable
extends Term {
    private static int nextVariableIndex = 0;
    private String name;
    private boolean userTyped = false;
    private boolean fresh = false;
    private boolean syntactic = false;
    private String expectedSort = null;
    private static final String GENERATED_FRESH_VAR = "GeneratedFreshVar";

    public String getExpectedSort() {
        return this.expectedSort;
    }

    public void setExpectedSort(String expectedSort) {
        this.expectedSort = expectedSort;
    }

    public Variable(Element element) {
        super(element);
        this.sort = element.getAttribute("sort");
        this.name = element.getAttribute("name");
        this.userTyped = element.getAttribute("userTyped").equals("true");
        if (this.name.startsWith("?")) {
            this.setFresh(true);
            this.name = this.name.substring(1);
        }
    }

    public Variable(ATermAppl atm) {
        super(atm);
        this.sort = StringUtil.getSortNameFromCons(atm.getName());
        this.name = ((ATermAppl)atm.getArgument(0)).getName();
        if (atm.getName().endsWith("2Var")) {
            this.userTyped = true;
        }
        if (this.name.startsWith("?")) {
            this.setFresh(true);
            this.name = this.name.substring(1);
        }
    }

    public Variable(String name, String sort) {
        super(sort);
        this.name = name;
    }

    public Variable(Variable variable) {
        super(variable);
        this.name = variable.name;
        this.fresh = variable.fresh;
        this.userTyped = variable.userTyped;
        this.syntactic = variable.syntactic;
        this.expectedSort = variable.expectedSort;
    }

    public static Variable getFreshVar(String sort) {
        return new Variable(GENERATED_FRESH_VAR + nextVariableIndex++, sort);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + ":" + this.sort + " ";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable var = (Variable)obj;
        return this.sort.equals(var.getSort()) && this.name.equals(var.getName());
    }

    @Override
    public int hashCode() {
        return this.sort.hashCode() + this.name.hashCode();
    }

    public void setUserTyped(boolean userTyped) {
        this.userTyped = userTyped;
    }

    public boolean isUserTyped() {
        return this.userTyped;
    }

    @Override
    public Variable shallowCopy() {
        return new Variable(this);
    }

    public void setFresh(boolean fresh) {
        this.fresh = fresh;
    }

    public boolean isFresh() {
        return this.fresh;
    }

    public boolean isGenerated() {
        return this.name.startsWith(GENERATED_FRESH_VAR);
    }

    public boolean isSyntactic() {
        return this.syntactic;
    }

    public void setSyntactic(boolean syntactic) {
        this.syntactic = syntactic;
    }
}

