/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.loader;

import org.kframework.kil.Attribute;
import org.kframework.kil.Production;
import org.kframework.kil.Terminal;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.StringUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class AddConsesVisitor
extends BasicVisitor {
    public AddConsesVisitor(Context context) {
        super(context);
    }

    @Override
    public void visit(Production p) {
        if (p.containsAttribute("bracket")) {
            String cons = p.getAttribute("cons");
            String cons2 = StringUtil.escapeSortName(p.getSort()) + "1Bracket";
            if (cons != null) {
                if (!cons.equals(cons2)) {
                    String msg = "Cons must be of the form: '" + cons2 + "'";
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, p.getFilename(), p.getLocation()));
                }
            } else {
                p.putAttribute("cons", cons2);
            }
        } else if (p.getItems().size() == 1 && p.getItems().get(0) instanceof Terminal && (p.getSort().startsWith("#") || p.getSort().equals("KLabel"))) {
            String cons = p.getAttribute("cons");
            if (cons != null) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Constants are not allowed to have cons: '" + cons + "'", p.getFilename(), p.getLocation()));
            }
        } else if (!p.isLexical()) {
            if (p.isSubsort()) {
                String cons = p.getAttribute("cons");
                if (cons != null && !p.containsAttribute("klabel")) {
                    String msg = "Subsortings are not allowed to have cons without klabel: '" + cons + "'";
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, p.getFilename(), p.getLocation()));
                }
                if (p.containsAttribute("klabel") && !p.containsAttribute("cons")) {
                    p.putAttribute("cons", StringUtil.escapeSortName(p.getSort()) + "1" + StringUtil.getUniqueId() + "Syn");
                }
            } else if (!p.containsAttribute("cons")) {
                String cons = p.isListDecl() ? StringUtil.escapeSortName(p.getSort()) + "1" + "ListSyn" : StringUtil.escapeSortName(p.getSort()) + "1" + StringUtil.getUniqueId() + "Syn";
                p.addAttribute(new Attribute("cons", cons));
            } else {
                String msg;
                String escSort;
                String cons = p.getAttribute("cons");
                if (!cons.startsWith(escSort = StringUtil.escapeSortName(p.getSort()))) {
                    msg = "The cons attribute must start with '" + escSort + "' and not with " + cons;
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, p.getFilename(), p.getLocation()));
                }
                if (!cons.endsWith("Syn")) {
                    msg = "The cons attribute must end with 'Syn' and not with " + cons;
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, p.getFilename(), p.getLocation()));
                }
                if (p.isListDecl() && !cons.endsWith("ListSyn")) {
                    msg = "The cons attribute must end with 'ListSyn' and not with " + cons;
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, p.getFilename(), p.getLocation()));
                }
            }
        }
    }
}

