/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.loader;

import org.kframework.kil.Definition;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;

public class CollectSubsortsVisitor
extends BasicVisitor {
    public CollectSubsortsVisitor(Context context) {
        super(context);
    }

    @Override
    public void visit(Definition def) {
        super.visit(def);
        this.context.finalizeSubsorts();
    }

    @Override
    public void visit(Syntax syn) {
        String sortName;
        if (syn.getPriorityBlocks().size() == 0 && !(sortName = syn.getSort().getName()).equals("KItem")) {
            this.context.addSubsort("KItem", syn.getSort().getName());
        }
        super.visit(syn);
    }

    @Override
    public void visit(Production prd) {
        if (!Sort.isBasesort(prd.getSort())) {
            this.context.addSubsort("KItem", prd.getSort());
        }
        if (prd.isSubsort()) {
            if (!prd.containsAttribute("onlyLabel") && !prd.containsAttribute("notInRules")) {
                Sort srt = (Sort)prd.getItems().get(0);
                this.context.addSubsort(prd.getSort(), srt.toString());
            }
        } else if (prd.isListDecl()) {
            UserList srt = (UserList)prd.getItems().get(0);
            this.context.listConses.put(prd.getSort(), prd);
            this.context.putListLabel(prd);
            this.context.addSubsort(prd.getSort(), srt.getSort());
        } else {
            for (ProductionItem pi : prd.getItems()) {
                Sort s;
                if (!(pi instanceof Sort) || (s = (Sort)pi).isBaseSort()) continue;
                this.context.addSubsort("KItem", s.getName());
            }
        }
    }
}

