/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.loader;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kframework.compile.utils.ConfigurationStructureMap;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.CellDataStructure;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.Production;
import org.kframework.kil.Sort;
import org.kframework.kil.Term;
import org.kframework.kil.UserList;
import org.kframework.utils.Poset;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class Context
implements Serializable {
    public static final Set<String> generatedTags = ImmutableSet.of("cons", "kgeneratedlabel", "prefixlabel");
    public static final Set<String> parsingTags = ImmutableSet.of("left", "right", "non-assoc");
    public static final Set<String> specialTerminals = ImmutableSet.of("(", ")", ",", "[", "]", "{", new String[]{"}"});
    public BiMap<String, Production> conses = HashBiMap.create();
    public Map<String, Set<Production>> productions = new HashMap<String, Set<Production>>();
    public Map<String, Set<String>> labels = new HashMap<String, Set<String>>();
    public Map<String, Cell> cells = new HashMap<String, Cell>();
    public Map<String, String> cellKinds = new HashMap<String, String>();
    public Map<String, String> cellSorts = new HashMap<String, String>();
    public Map<String, Production> listConses = new HashMap<String, Production>();
    public Map<String, Set<String>> listLabels = new HashMap<String, Set<String>>();
    public Map<String, ASTNode> locations = new HashMap<String, ASTNode>();
    public Map<String, Set<Production>> associativity = new HashMap<String, Set<Production>>();
    private Poset subsorts = new Poset();
    public Set<String> definedSorts = Sort.getBaseSorts();
    private Poset priorities = new Poset();
    private Poset modules = new Poset();
    private Poset fileRequirements = new Poset();
    public String startSymbolPgm = "K";
    public Map<String, String> configVarSorts = new HashMap<String, String>();
    public File dotk = null;
    public File kompiled = null;
    public boolean initialized = false;
    protected List<String> komputationCells = null;
    public Map<String, CellDataStructure> cellDataStructures = new HashMap<String, CellDataStructure>();
    public Set<String> variableTokenSorts = new HashSet<String>();
    public int numModules;
    public int numSentences;
    public int numProductions;
    public int numCells;
    private ConfigurationStructureMap configurationStructureMap = new ConfigurationStructureMap();
    private int maxConfigurationLevel = -1;
    private Map<String, DataStructureSort> dataStructureSorts;
    private Set<String> tokenSorts;
    public static final int HASH_PRIME = 37;
    private static final String fragment = "-fragment";

    public void printStatistics() {
        Formatter f = new Formatter(System.out);
        f.format("%n", new Object[0]);
        f.format("%-60s = %5d%n", "Number of Modules", this.numModules);
        f.format("%-60s = %5d%n", "Number of Sentences", this.numSentences);
        f.format("%-60s = %5d%n", "Number of Productions", this.numProductions);
        f.format("%-60s = %5d%n", "Number of Cells", this.numCells);
    }

    public List<String> getKomputationCells() {
        return this.komputationCells;
    }

    public void setKomputationCells(List<String> komputationCells) {
        this.komputationCells = komputationCells;
    }

    public ConfigurationStructureMap getConfigurationStructureMap() {
        return this.configurationStructureMap;
    }

    public int getMaxConfigurationLevel() {
        return this.maxConfigurationLevel;
    }

    public void setMaxConfigurationLevel(int maxConfigurationLevel) {
        this.maxConfigurationLevel = maxConfigurationLevel;
    }

    private void initSubsorts() {
        this.subsorts.addRelation("KList", "K");
        this.subsorts.addRelation("KList", "KResult");
        this.subsorts.addRelation("K", "KResult");
        this.subsorts.addRelation("K", "KItem");
        this.subsorts.addRelation("Map", "MapItem");
        this.subsorts.addRelation("Set", "SetItem");
        this.subsorts.addRelation("List", "ListItem");
        this.subsorts.addRelation("Bag", "BagItem");
    }

    public Context() {
        this.initSubsorts();
    }

    public void putLabel(Production p, String cons) {
        this.putLabel(p.getLabel(), cons);
        this.putLabel(p.getKLabel(), cons);
    }

    private void putLabel(String label, String cons) {
        Set<String> s = this.labels.get(label);
        if (s == null) {
            s = new HashSet<String>();
            this.labels.put(label, s);
        }
        s.add(cons);
    }

    public void putListLabel(Production p) {
        String separator = ((UserList)p.getItems().get(0)).getSeparator();
        String label = MetaK.getListUnitLabel(separator);
        Set<String> s = this.listLabels.get(label);
        if (s == null) {
            s = new HashSet<String>();
            this.listLabels.put(label, s);
        }
        s.add(p.getSort());
    }

    public void putAssoc(String cons, Collection<Production> prods) {
        if (this.associativity.get(cons) == null) {
            this.associativity.put(cons, new HashSet<Production>(prods));
        } else {
            this.associativity.get(cons).addAll(prods);
        }
    }

    public void addCellDecl(Cell c) {
        this.cells.put(c.getLabel(), c);
        String kind = this.subsorts.getMaxim(c.getContents().getSort());
        if (kind.equals("KList")) {
            kind = "K";
        }
        this.cellKinds.put(c.getLabel(), kind);
        String sort = c.getCellAttributes().get(Cell.SORT_ATTRIBUTE);
        if (sort == null) {
            sort = c.getContents().getSort();
        }
        this.cellSorts.put(c.getLabel(), sort);
    }

    public boolean isListSort(String sort) {
        return this.listConses.containsKey(sort);
    }

    public Set<String> getAllSorts() {
        return Collections.unmodifiableSet(this.subsorts.getElements());
    }

    public String getListElementSort(String sort) {
        if (!this.isListSort(sort)) {
            return null;
        }
        return ((UserList)this.listConses.get(sort).getItems().get(0)).getSort();
    }

    public String getLUBSort(Set<String> sorts) {
        return this.subsorts.getLUB(sorts);
    }

    public String getGLBSort(Set<String> sorts) {
        return this.subsorts.getGLB(sorts);
    }

    public Set<String> getCommonSubsorts(Set<String> sorts) {
        return this.subsorts.getMaximalLowerBounds(sorts);
    }

    public void addPriority(String bigPriority, String smallPriority) {
        this.priorities.addRelation(bigPriority, smallPriority);
    }

    public void finalizePriority() {
        this.priorities.transitiveClosure();
    }

    public boolean isPriorityWrong(String klabelParent, String klabelChild) {
        return this.priorities.isInRelation(klabelParent, klabelChild);
    }

    public void addFileRequirement(String required, String local) {
        if (required.equals(local)) {
            return;
        }
        this.fileRequirements.addRelation(required, local);
    }

    public void finalizeRequirements() {
        this.fileRequirements.transitiveClosure();
    }

    public void addModuleImport(String mainModule, String importedModule) {
        if (mainModule.equals(importedModule)) {
            return;
        }
        this.modules.addRelation(mainModule, importedModule);
    }

    public void finalizeModules() {
        this.modules.transitiveClosure();
    }

    public boolean isModuleIncluded(String localModule, String importedModule) {
        return this.modules.isInRelation(localModule, importedModule);
    }

    public boolean isModuleIncludedEq(String localModule, String importedModule) {
        if (localModule.equals(importedModule)) {
            return true;
        }
        return this.modules.isInRelation(localModule, importedModule);
    }

    public boolean isRequiredEq(String required, String local) {
        try {
            required = new File(required).getCanonicalPath();
            local = new File(local).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (required.equals(local)) {
            return true;
        }
        return this.fileRequirements.isInRelation(required, local);
    }

    public void addSubsort(String bigSort, String smallSort) {
        this.subsorts.addRelation(bigSort, smallSort);
    }

    public void finalizeSubsorts() {
        List<String> circuit = this.subsorts.checkForCycles();
        if (circuit != null) {
            String msg = "Circularity detected in subsorts: ";
            for (String sort : circuit) {
                msg = msg + sort + " < ";
            }
            msg = msg + circuit.get(0);
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, "Definition files", "File system."));
        }
        this.subsorts.transitiveClosure();
        for (Map.Entry<String, Production> ls1 : this.listConses.entrySet()) {
            for (Map.Entry<String, Production> ls2 : this.listConses.entrySet()) {
                String sort2;
                String sort1 = ((UserList)ls1.getValue().getItems().get(0)).getSort();
                if (!this.isSubsorted(sort1, sort2 = ((UserList)ls2.getValue().getItems().get(0)).getSort())) continue;
                this.subsorts.addRelation(ls1.getValue().getSort(), ls2.getValue().getSort());
            }
        }
        this.subsorts.transitiveClosure();
    }

    public boolean isSubsorted(String bigSort, String smallSort) {
        return this.subsorts.isInRelation(bigSort, smallSort);
    }

    public boolean isSubsortedEq(String bigSort, String smallSort) {
        if (bigSort.equals(smallSort)) {
            return true;
        }
        return this.subsorts.isInRelation(bigSort, smallSort);
    }

    public boolean isTagGenerated(String key) {
        return generatedTags.contains(key);
    }

    public boolean isSpecialTerminal(String terminal) {
        return specialTerminals.contains(terminal);
    }

    public boolean isParsingTag(String key) {
        return parsingTags.contains(key);
    }

    public List<Production> productionsOf(String label) {
        Set<String> conses = this.labels.get(label);
        if (conses == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Production> productions = new ArrayList<Production>();
        for (String cons : conses) {
            assert (this.conses.containsKey(cons));
            productions.add((Production)this.conses.get(cons));
        }
        return productions;
    }

    public Term kWrapper(Term t) {
        if (this.isSubsortedEq("K", t.getSort())) {
            return t;
        }
        return KApp.of(new KInjectedLabel(t), new Term[0]);
    }

    private String getCellSort2(String sort) {
        if ((sort = sort.substring(0, 1).toLowerCase() + sort.substring(1)).endsWith("CellSort")) {
            return sort.substring(0, sort.length() - "CellSort".length());
        }
        return sort.substring(0, sort.length() - "CellFragment".length()) + fragment;
    }

    public String getCellSort(String sort) {
        String cellName = sort = this.getCellSort2(sort);
        if (sort.endsWith(fragment)) {
            cellName = sort.substring(0, sort.length() - fragment.length());
        }
        if (this.cells.containsKey(cellName)) {
            return sort;
        }
        return sort.substring(0, 1).toUpperCase() + sort.substring(1);
    }

    public Map<String, DataStructureSort> getDataStructureSorts() {
        return Collections.unmodifiableMap(this.dataStructureSorts);
    }

    public void setDataStructureSorts(Map<String, DataStructureSort> dataStructureSorts) {
        assert (!this.initialized);
        this.dataStructureSorts = new HashMap<String, DataStructureSort>(dataStructureSorts);
    }

    public DataStructureSort dataStructureSortOf(String sortName) {
        assert (this.initialized) : "Context is not initialized yet";
        return this.dataStructureSorts.get(sortName);
    }

    public DataStructureSort dataStructureListSortOf(String sortName) {
        assert (this.initialized) : "Context is not initialized yet";
        DataStructureSort sort = this.dataStructureSorts.get(sortName);
        if (sort == null) {
            return null;
        }
        if (!sort.type().equals("List")) {
            return null;
        }
        return sort;
    }

    public Set<String> getTokenSorts() {
        return Collections.unmodifiableSet(this.tokenSorts);
    }

    public void setTokenSorts(Set<String> tokenSorts) {
        assert (!this.initialized);
        this.tokenSorts = new HashSet<String>(tokenSorts);
    }
}

