/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Definition;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.Import;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.loader.Constants;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class RemoveUnusedModules
extends CopyOnWriteTransformer {
    private boolean autoinclude;

    public RemoveUnusedModules(Context context, boolean autoinclude) {
        super(RemoveUnusedModules.class.toString(), context);
        this.autoinclude = autoinclude;
    }

    @Override
    public ASTNode transform(Definition def) throws TransformerException {
        boolean change = false;
        HashSet<String> initialModules = new HashSet<String>();
        if (this.autoinclude) {
            initialModules.add("AUTO-INCLUDED-MODULE");
            initialModules.add(Constants.AUTO_INCLUDED_SYNTAX_MODULE);
        }
        initialModules.add(def.getMainModule());
        CollectReachableModulesVisitor fm = new CollectReachableModulesVisitor(this.context, initialModules);
        def.accept(fm);
        ArrayList<DefinitionItem> reachableModulesList = new ArrayList<DefinitionItem>();
        HashMap<String, Module> reachableModulesMap = fm.getResult();
        for (DefinitionItem definitionItem : def.getItems()) {
            String name;
            if (definitionItem instanceof Module && !reachableModulesMap.containsKey(name = ((Module)definitionItem).getName())) {
                change = true;
                continue;
            }
            reachableModulesList.add(definitionItem);
        }
        if (change) {
            def = def.shallowCopy();
            def.setItems(reachableModulesList);
            def.setModulesMap(reachableModulesMap);
        }
        return def;
    }

    @Override
    public String getName() {
        return "Flatten Modules";
    }

    private class CollectReachableModulesVisitor
    extends BasicVisitor {
        HashMap<String, Module> included;
        private Collection<String> initialModules;

        public CollectReachableModulesVisitor(Context context, Collection<String> initialModules) {
            super(context);
            this.initialModules = initialModules;
            this.included = new HashMap();
        }

        @Override
        public void visit(Definition d) {
            LinkedList<Module> mods = new LinkedList<Module>();
            for (String name : this.initialModules) {
                Module mainModule = d.getModulesMap().get(name);
                mods.add(mainModule);
                this.included.put(name, mainModule);
            }
            while (!mods.isEmpty()) {
                Module mod = (Module)mods.remove();
                if (null == mod.getItems()) continue;
                for (ModuleItem i : mod.getItems()) {
                    Module mod1;
                    String name;
                    if (!(i instanceof Import) || this.included.containsKey(name = ((Import)i).getName()) || (mod1 = d.getModulesMap().get(name)) == null) continue;
                    mods.add(mod1);
                    this.included.put(name, mod1);
                }
            }
        }

        public HashMap<String, Module> getResult() {
            return this.included;
        }
    }
}

