/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.loader;

import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Token;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.K;

public class ResolveVariableAttribute
extends CopyOnWriteTransformer {
    public ResolveVariableAttribute(Context context) {
        super("Resolve 'variable' attribute", context);
    }

    @Override
    public ASTNode transform(KApp kapp) throws TransformerException {
        if (kapp.getLabel() instanceof Token) {
            Token node = (Token)kapp.getLabel();
            if (K.backend.equals("maude") && this.context.variableTokenSorts.contains(node.tokenSort())) {
                String sort = "K";
                String name = node.value();
                int index = node.value().lastIndexOf(":");
                if (index > 0) {
                    sort = node.value().substring(index + 1);
                    name = node.value().substring(0, index);
                }
                if (MetaK.isDataSort("#" + sort)) {
                    return KApp.of(KLabelConstant.of(AddSymbolicK.symbolicConstructor(sort)), Token.kAppOf("#Id", name));
                }
                return KApp.of(KLabelConstant.of(AddSymbolicK.symbolicConstructor("K")), Token.kAppOf("#Id", node.value()));
            }
            if (this.context.variableTokenSorts.contains(node.tokenSort())) {
                return new Variable(node.value(), node.tokenSort());
            }
        }
        return super.transform(kapp);
    }
}

