/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.matchers;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cast;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.matchers.Binding;
import org.kframework.kil.matchers.MatchCompilationException;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class MapInsertPattern
extends Term {
    private List<Binding> insertions;
    private Variable remainder;

    public MapInsertPattern(Map m, Context context) {
        List<Term> contents = m.getContents();
        this.insertions = new ArrayList<Binding>(contents.size());
        for (Term t : contents) {
            if (t instanceof Variable) {
                if (!t.getSort().equals("Map")) {
                    throw new MatchCompilationException("Variable in Map pattern does not have sort Map: " + t);
                }
                if (this.remainder != null) {
                    throw new MatchCompilationException("Map pattern has more than one remainder variable, i.e.,  more than one variable at the top level: " + m);
                }
                this.remainder = (Variable)t;
                continue;
            }
            if (t instanceof MapItem) {
                MapItem mi = (MapItem)t;
                this.insertions.add(new Binding(mi.getKey(), mi.getValue()));
                continue;
            }
            throw new MatchCompilationException("Map pattern contains a Term that is neither a Variable of sort Map nor a MapItem.  This is not supported.  Map is: " + m);
        }
    }

    public MapInsertPattern(MapInsertPattern mp) {
        this.insertions = mp.insertions;
        this.remainder = mp.remainder;
    }

    public List<Binding> getInsertions() {
        return this.insertions;
    }

    public Variable getRemainder() {
        return this.remainder;
    }

    public String toString() {
        return "mapInsertPattern(" + this.insertions.toString() + ", " + this.remainder + ")";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    @Override
    public MapInsertPattern shallowCopy() {
        return new MapInsertPattern(this);
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return o instanceof Cast;
    }
}

