/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.matchers;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cast;
import org.kframework.kil.Set;
import org.kframework.kil.SetItem;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.matchers.MatchCompilationException;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class SetLookupPattern
extends Term {
    private List<Term> lookups;
    private Variable remainder;

    public SetLookupPattern(Set s) {
        List<Term> contents = s.getContents();
        this.lookups = new ArrayList<Term>(contents.size());
        for (Term t : contents) {
            if (t instanceof Variable) {
                if (!t.getSort().equals("Set")) {
                    throw new MatchCompilationException("Variable in Set pattern does not have sort Set: " + t);
                }
                if (this.remainder != null) {
                    throw new MatchCompilationException("Set pattern has more than one remainder variable, i.e.,  more than one variable at the top level: " + s);
                }
                this.remainder = (Variable)t;
                continue;
            }
            if (t instanceof SetItem) {
                SetItem si = (SetItem)t;
                this.lookups.add(si.getItem());
                continue;
            }
            throw new MatchCompilationException("Set pattern contains a Term that is neither a Variable of sort Set nor a SetItem.  This is not supported.  Set is: " + s);
        }
    }

    public SetLookupPattern(SetLookupPattern sp) {
        this.lookups = sp.lookups;
        this.remainder = sp.remainder;
    }

    public List<Term> getLookups() {
        return this.lookups;
    }

    public Variable getRemainder() {
        return this.remainder;
    }

    public String toString() {
        return "mapLookUpPattern(" + this.lookups.toString() + ", " + this.remainder + ")";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    @Override
    public SetLookupPattern shallowCopy() {
        return new SetLookupPattern(this);
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return o instanceof Cast;
    }
}

