/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.rewriter;

import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.matchers.Binding;
import org.kframework.kil.matchers.MapInsertPattern;
import org.kframework.kil.matchers.SetInsertPattern;
import org.kframework.kil.rewriter.MapImpl;
import org.kframework.kil.rewriter.SetImpl;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class RewriteSubstitution
extends CopyOnWriteTransformer {
    Map<Term, Term> substitution;

    public RewriteSubstitution(Map<Term, Term> substitution, Context context) {
        super("Substitution", context);
        this.substitution = substitution;
    }

    private MapImpl rewriteMap(MapInsertPattern mip) {
        Variable remainder = mip.getRemainder();
        MapImpl map = (MapImpl)this.substitution.get(remainder);
        assert (map != null);
        for (Binding b : mip.getInsertions()) {
            Term newKey = this.substitution.get(b.getKey());
            Term newValue = this.substitution.get(b.getValue());
            if (newKey == null) {
                newKey = b.getKey();
            }
            if (newValue == null) {
                newValue = b.getValue();
            }
            map.put(newKey, newValue);
        }
        return map;
    }

    private SetImpl rewriteSet(SetInsertPattern sip) {
        Variable remainder = sip.getRemainder();
        SetImpl set = (SetImpl)this.substitution.get(remainder);
        assert (set != null);
        for (Term t : sip.getInsertions()) {
            Term newValue = this.substitution.get(t);
            if (newValue == null) {
                newValue = t;
            }
            set.add(newValue);
        }
        return set;
    }

    @Override
    public ASTNode transform(Term node) throws TransformerException {
        if (node instanceof MapInsertPattern) {
            return super.transform(this.rewriteMap((MapInsertPattern)node));
        }
        if (node instanceof SetInsertPattern) {
            return super.transform(this.rewriteSet((SetInsertPattern)node));
        }
        Term substitute = this.substitution.get(node);
        if (substitute != null) {
            node = substitute;
        }
        return super.transform(node);
    }
}

