/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.rewriter;

import org.kframework.kil.Rewrite;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.matchers.MatcherException;
import org.kframework.kil.matchers.SimpleMatcher;
import org.kframework.kil.rewriter.RewriteSet;
import org.kframework.kil.rewriter.RewriteSubstitution;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class SimpleRewriter {
    protected Context context;
    protected Matcher matcher;

    public SimpleRewriter(Context context) {
        this.context = context;
        this.matcher = new SimpleMatcher(context);
    }

    private Term rewriteAux(RewriteSet trs, Term t) {
        Term out = null;
        for (Rewrite r : trs) {
            try {
                this.matcher.start(r.getLeft(), t);
                RewriteSubstitution substitution = new RewriteSubstitution(this.matcher.getSubstitution(), this.context);
                try {
                    out = (Term)r.getRight().accept(substitution);
                    break;
                }
                catch (TransformerException te) {
                    System.err.println("Failed to perform substitution on rhs " + r.getRight() + " with substitution " + this.matcher.getSubstitution());
                    throw new RuntimeException(te);
                }
            }
            catch (MatcherException pe) {
            }
        }
        return out;
    }

    public Term rewrite(RewriteSet trs, Term t) {
        Term temp = this.rewriteAux(trs, t);
        return temp == null ? t : temp;
    }

    public Term rewriteToNormalForm(RewriteSet trs, Term t) {
        Term out = t;
        Term temp = t;
        while ((temp = this.rewriteAux(trs, out = temp)) != null) {
        }
        return out;
    }

    public Term rewriteN(RewriteSet trs, Term t, int n) {
        Term out = t;
        Term temp = t;
        for (int i = 0; i <= n && temp != null; ++i) {
            out = temp;
            temp = this.rewriteAux(trs, out);
        }
        return out;
    }

    public static void main(String[] args) {
    }
}

