/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil.visitors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.BackendTerm;
import org.kframework.kil.Bag;
import org.kframework.kil.BagItem;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.CollectionBuiltin;
import org.kframework.kil.CollectionItem;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Definition;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.Freezer;
import org.kframework.kil.FreezerHole;
import org.kframework.kil.FreezerLabel;
import org.kframework.kil.GenericToken;
import org.kframework.kil.Hole;
import org.kframework.kil.Import;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KItemProjection;
import org.kframework.kil.KLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KLabelInjection;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.Lexical;
import org.kframework.kil.List;
import org.kframework.kil.ListBuiltin;
import org.kframework.kil.ListItem;
import org.kframework.kil.ListLookup;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.ListUpdate;
import org.kframework.kil.LiterateDefinitionComment;
import org.kframework.kil.LiterateModuleComment;
import org.kframework.kil.Map;
import org.kframework.kil.MapBuiltin;
import org.kframework.kil.MapItem;
import org.kframework.kil.MapLookup;
import org.kframework.kil.MapUpdate;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.ParseError;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.PriorityBlockExtended;
import org.kframework.kil.PriorityExtended;
import org.kframework.kil.PriorityExtendedAssoc;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Restrictions;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.Set;
import org.kframework.kil.SetBuiltin;
import org.kframework.kil.SetItem;
import org.kframework.kil.SetLookup;
import org.kframework.kil.SetUpdate;
import org.kframework.kil.Sort;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.StringSentence;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.Token;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class BasicTransformer
implements Transformer {
    protected org.kframework.kil.loader.Context context;
    private String name;

    public BasicTransformer(String name, org.kframework.kil.loader.Context context) {
        this.name = name;
        this.context = context;
    }

    @Override
    public ASTNode transform(ASTNode node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(ParseError node) throws TransformerException {
        return this.transform((ASTNode)node);
    }

    @Override
    public ASTNode transform(Definition node) throws TransformerException {
        for (int i = 0; i < node.getItems().size(); ++i) {
            node.getItems().set(i, (DefinitionItem)node.getItems().get(i).accept(this));
        }
        return this.transform((ASTNode)node);
    }

    @Override
    public ASTNode transform(DefinitionItem node) throws TransformerException {
        return this.transform((ASTNode)node);
    }

    @Override
    public ASTNode transform(LiterateDefinitionComment node) throws TransformerException {
        return this.transform((DefinitionItem)node);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        for (int i = 0; i < node.getItems().size(); ++i) {
            node.getItems().set(i, (ModuleItem)node.getItems().get(i).accept(this));
        }
        return this.transform((DefinitionItem)node);
    }

    @Override
    public ASTNode transform(ModuleItem node) throws TransformerException {
        return this.transform((ASTNode)node);
    }

    @Override
    public ASTNode transform(Import node) throws TransformerException {
        return this.transform((ModuleItem)node);
    }

    @Override
    public ASTNode transform(LiterateModuleComment node) throws TransformerException {
        return this.transform((ModuleItem)node);
    }

    @Override
    public ASTNode transform(Sentence node) throws TransformerException {
        Term ensures;
        Term body = (Term)node.getBody().accept(this);
        Term requires = node.getRequires();
        if (requires != null) {
            requires = (Term)requires.accept(this);
        }
        if ((ensures = node.getEnsures()) != null) {
            ensures = (Term)ensures.accept(this);
        }
        node.setBody(body);
        node.setRequires(requires);
        node.setEnsures(ensures);
        return this.transform((ModuleItem)node);
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        Configuration c = node.shallowCopy();
        return this.transform((Sentence)c);
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        Context c = node.shallowCopy();
        return this.transform((Sentence)c);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        Rule r = node.shallowCopy();
        return this.transform((Sentence)r);
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        node.setSort((Sort)node.getSort().accept(this));
        for (int i = 0; i < node.getPriorityBlocks().size(); ++i) {
            node.getPriorityBlocks().set(i, (PriorityBlock)node.getPriorityBlocks().get(i).accept(this));
        }
        return this.transform((ModuleItem)node);
    }

    @Override
    public ASTNode transform(PriorityExtended node) throws TransformerException {
        for (int i = 0; i < node.getPriorityBlocks().size(); ++i) {
            node.getPriorityBlocks().set(i, (PriorityBlockExtended)node.getPriorityBlocks().get(i).accept(this));
        }
        return this.transform((ModuleItem)node);
    }

    @Override
    public ASTNode transform(PriorityExtendedAssoc node) throws TransformerException {
        for (int i = 0; i < node.getTags().size(); ++i) {
            node.getTags().set(i, (KLabelConstant)node.getTags().get(i).accept(this));
        }
        return this.transform((ModuleItem)node);
    }

    @Override
    public ASTNode transform(PriorityBlock node) throws TransformerException {
        for (int i = 0; i < node.getProductions().size(); ++i) {
            node.getProductions().set(i, (Production)node.getProductions().get(i).accept(this));
        }
        return this.transform((ASTNode)node);
    }

    @Override
    public ASTNode transform(PriorityBlockExtended node) throws TransformerException {
        for (int i = 0; i < node.getProductions().size(); ++i) {
            node.getProductions().set(i, (KLabelConstant)node.getProductions().get(i).accept(this));
        }
        return this.transform((ASTNode)node);
    }

    @Override
    public ASTNode transform(Production node) throws TransformerException {
        for (int i = 0; i < node.getItems().size(); ++i) {
            node.getItems().set(i, (ProductionItem)node.getItems().get(i).accept(this));
        }
        return this.transform((ASTNode)node);
    }

    @Override
    public ASTNode transform(ProductionItem node) throws TransformerException {
        return this.transform((ASTNode)node);
    }

    @Override
    public ASTNode transform(Sort node) throws TransformerException {
        return this.transform((ProductionItem)node);
    }

    @Override
    public ASTNode transform(Terminal node) throws TransformerException {
        return this.transform((ProductionItem)node);
    }

    @Override
    public ASTNode transform(Lexical node) throws TransformerException {
        return this.transform((ProductionItem)node);
    }

    @Override
    public ASTNode transform(UserList node) throws TransformerException {
        return this.transform((ProductionItem)node);
    }

    @Override
    public ASTNode transform(Term node) throws TransformerException {
        return this.transform((ASTNode)node);
    }

    @Override
    public ASTNode transform(Cell node) throws TransformerException {
        Cell result = node.shallowCopy();
        result.setContents((Term)node.getContents().accept(this));
        return this.transform((Term)result);
    }

    @Override
    public ASTNode transform(Collection node) throws TransformerException {
        for (int i = 0; i < node.getContents().size(); ++i) {
            node.getContents().set(i, (Term)node.getContents().get(i).accept(this));
        }
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(Ambiguity node) throws TransformerException {
        TransformerException exception = null;
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Term t : node.getContents()) {
            try {
                ASTNode result = t.accept(this);
                terms.add((Term)result);
            }
            catch (TransformerException e) {
                exception = e;
            }
        }
        if (terms.isEmpty()) {
            throw exception;
        }
        if (terms.size() == 1) {
            return (ASTNode)terms.get(0);
        }
        node.setContents(terms);
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(Bag node) throws TransformerException {
        Bag result = node.shallowCopy();
        return this.transform((Collection)result);
    }

    @Override
    public ASTNode transform(KSequence node) throws TransformerException {
        KSequence result = node.shallowCopy();
        return this.transform((Collection)result);
    }

    @Override
    public ASTNode transform(List node) throws TransformerException {
        List result = node.shallowCopy();
        return this.transform((Collection)result);
    }

    @Override
    public ASTNode transform(KList node) throws TransformerException {
        KList result = node.shallowCopy();
        return this.transform((Collection)result);
    }

    @Override
    public ASTNode transform(Map node) throws TransformerException {
        Map result = node.shallowCopy();
        return this.transform((Collection)result);
    }

    @Override
    public ASTNode transform(Set node) throws TransformerException {
        Set result = node.shallowCopy();
        return this.transform((Collection)result);
    }

    @Override
    public ASTNode transform(CollectionItem node) throws TransformerException {
        node.setItem((Term)node.getItem().accept(this));
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(BagItem node) throws TransformerException {
        BagItem result = node.shallowCopy();
        return this.transform((CollectionItem)result);
    }

    @Override
    public ASTNode transform(ListItem node) throws TransformerException {
        ListItem result = node.shallowCopy();
        return this.transform((CollectionItem)result);
    }

    @Override
    public ASTNode transform(MapItem node) throws TransformerException {
        MapItem result = node.shallowCopy();
        result.setKey((Term)node.getKey().accept(this));
        result.setValue((Term)node.getValue().accept(this));
        return this.transform((CollectionItem)result);
    }

    @Override
    public ASTNode transform(SetItem node) throws TransformerException {
        SetItem result = node.shallowCopy();
        return this.transform((CollectionItem)result);
    }

    @Override
    public ASTNode transform(CollectionBuiltin node) throws TransformerException {
        ArrayList<Term> terms = new ArrayList<Term>(node.baseTerms().size());
        for (Term term : node.baseTerms()) {
            Term transformedTerm = (Term)term.accept(this);
            terms.add(transformedTerm);
        }
        ArrayList<Term> elements = new ArrayList<Term>(node.elements().size());
        for (Term term : node.elements()) {
            Term transformedTerm = (Term)term.accept(this);
            elements.add(transformedTerm);
        }
        return CollectionBuiltin.of(node.sort(), terms, elements);
    }

    @Override
    public ASTNode transform(SetBuiltin node) throws TransformerException {
        return this.transform((CollectionBuiltin)node);
    }

    @Override
    public ASTNode transform(SetLookup node) throws TransformerException {
        Variable set = (Variable)node.base().accept(this);
        Term value = (Term)node.key().accept(this);
        return new SetLookup(set, value, node.choice());
    }

    @Override
    public ASTNode transform(SetUpdate node) throws TransformerException {
        Variable set = (Variable)node.set().accept(this);
        HashSet<Term> removeEntries = new HashSet<Term>(node.removeEntries().size());
        for (Term term : node.removeEntries()) {
            Term transformedTerm = (Term)term.accept(this);
            removeEntries.add(transformedTerm);
        }
        return new SetUpdate(set, removeEntries);
    }

    @Override
    public ASTNode transform(ListBuiltin node) throws TransformerException {
        ArrayList<Term> terms = new ArrayList<Term>(node.baseTerms().size());
        for (Term term : node.baseTerms()) {
            Term transformedTerm = (Term)term.accept(this);
            terms.add(transformedTerm);
        }
        ArrayList<Term> elementsLeft = new ArrayList<Term>(node.elementsLeft().size());
        for (Term entry : node.elementsLeft()) {
            Term transformedEntry = (Term)entry.accept(this);
            elementsLeft.add(transformedEntry);
        }
        ArrayList<Term> elementsRight = new ArrayList<Term>(node.elementsRight().size());
        for (Term entry : node.elementsRight()) {
            Term transformedEntry = (Term)entry.accept(this);
            elementsRight.add(transformedEntry);
        }
        return ListBuiltin.of(node.sort(), elementsLeft, elementsRight, terms);
    }

    @Override
    public ASTNode transform(ListLookup node) throws TransformerException {
        Variable base = (Variable)node.base().accept(this);
        Term key = (Term)node.key().accept(this);
        Term value = (Term)node.value().accept(this);
        return new ListLookup(base, key, value, node.kind());
    }

    @Override
    public ASTNode transform(ListUpdate node) throws TransformerException {
        Variable base = (Variable)node.base().accept(this);
        ArrayList<Term> removeLeft = new ArrayList<Term>(node.removeLeft().size());
        for (Term entry : node.removeLeft()) {
            Term transformedEntry = (Term)entry.accept(this);
            removeLeft.add(transformedEntry);
        }
        ArrayList<Term> removeRight = new ArrayList<Term>(node.removeRight().size());
        for (Term entry : node.removeRight()) {
            Term transformedEntry = (Term)entry.accept(this);
            removeRight.add(transformedEntry);
        }
        return new ListUpdate(base, removeLeft, removeRight);
    }

    @Override
    public ASTNode transform(MapBuiltin node) throws TransformerException {
        ArrayList<Term> terms = new ArrayList<Term>(node.baseTerms().size());
        for (Term term : node.baseTerms()) {
            Term transformedTerm = (Term)term.accept(this);
            terms.add(transformedTerm);
        }
        HashMap<Term, Term> elements = new HashMap<Term, Term>(node.elements().size());
        for (Map.Entry<Term, Term> entry : node.elements().entrySet()) {
            Term transformedKey = (Term)entry.getKey().accept(this);
            Term transformedValue = (Term)entry.getValue().accept(this);
            elements.put(transformedKey, transformedValue);
        }
        return new MapBuiltin(node.sort(), terms, elements);
    }

    @Override
    public ASTNode transform(MapLookup node) throws TransformerException {
        Variable map = (Variable)node.base().accept(this);
        Term key = (Term)node.key().accept(this);
        Term value = (Term)node.value().accept(this);
        return new MapLookup(map, key, value, node.kind(), node.choice());
    }

    @Override
    public ASTNode transform(MapUpdate node) throws TransformerException {
        Variable map = (Variable)node.map().accept(this);
        HashMap<Term, Term> removeEntries = new HashMap<Term, Term>(node.removeEntries().size());
        for (Map.Entry<Term, Term> entry : node.removeEntries().entrySet()) {
            Term transformedKey = (Term)entry.getKey().accept(this);
            Term transformedValue = (Term)entry.getValue().accept(this);
            removeEntries.put(transformedKey, transformedValue);
        }
        HashMap<Term, Term> updateEntries = new HashMap<Term, Term>(node.updateEntries().size());
        for (Map.Entry<Term, Term> entry : node.updateEntries().entrySet()) {
            Term transformedKey = (Term)entry.getKey().accept(this);
            Term transformedValue = (Term)entry.getValue().accept(this);
            updateEntries.put(transformedKey, transformedValue);
        }
        return new MapUpdate(map, removeEntries, updateEntries);
    }

    @Override
    public ASTNode transform(Token node) throws TransformerException {
        return this.transform((KLabel)node);
    }

    @Override
    public ASTNode transform(BoolBuiltin node) throws TransformerException {
        return this.transform((Token)node);
    }

    @Override
    public ASTNode transform(IntBuiltin node) throws TransformerException {
        return this.transform((Token)node);
    }

    @Override
    public ASTNode transform(StringBuiltin node) throws TransformerException {
        return this.transform((Token)node);
    }

    @Override
    public ASTNode transform(GenericToken node) throws TransformerException {
        return this.transform((Token)node);
    }

    @Override
    public ASTNode transform(ListTerminator node) throws TransformerException {
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(Hole node) throws TransformerException {
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(KApp node) throws TransformerException {
        KApp result = node.shallowCopy();
        result.setLabel((Term)node.getLabel().accept(this));
        Term resultChild = (Term)node.getChild().accept(this);
        if (!resultChild.getSort().equals("KList") && !(resultChild instanceof Ambiguity)) {
            result.setChild(new KList(Collections.singletonList(resultChild)));
        } else {
            result.setChild(resultChild);
        }
        return this.transform((Term)result);
    }

    @Override
    public ASTNode transform(KItemProjection node) throws TransformerException {
        Term term = (Term)node.getTerm().accept(this);
        node = node.shallowCopy();
        node.setTerm(term);
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(KLabel node) throws TransformerException {
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(KLabelConstant node) throws TransformerException {
        return this.transform((KLabel)node);
    }

    @Override
    public ASTNode transform(KLabelInjection node) throws TransformerException {
        Term term = (Term)node.getTerm().accept(this);
        node = node.shallowCopy();
        node.setTerm(term);
        return this.transform((KLabel)node);
    }

    @Override
    public ASTNode transform(Rewrite node) throws TransformerException {
        Rewrite result = node.shallowCopy();
        result.replaceChildren((Term)node.getLeft().accept(this), (Term)node.getRight().accept(this), this.context);
        return this.transform((Term)result);
    }

    @Override
    public ASTNode transform(TermCons node) throws TransformerException {
        for (int i = 0; i < node.getContents().size(); ++i) {
            node.getContents().set(i, (Term)node.getContents().get(i).accept(this));
        }
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(Bracket node) throws TransformerException {
        node.setContent((Term)node.getContent().accept(this));
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(Cast node) throws TransformerException {
        node.setContent((Term)node.getContent().accept(this));
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(Variable node) throws TransformerException {
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(Freezer node) throws TransformerException {
        Term term = (Term)node.getTerm().accept(this);
        Freezer result = node.shallowCopy();
        result.setTerm(term);
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(BackendTerm term) throws TransformerException {
        return this.transform((Term)term);
    }

    @Override
    public ASTNode transform(Attributes node) throws TransformerException {
        for (int i = 0; i < node.getContents().size(); ++i) {
            node.getContents().set(i, (Attribute)node.getContents().get(i).accept(this));
        }
        return node;
    }

    @Override
    public ASTNode transform(Attribute node) throws TransformerException {
        return this.transform(node);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ASTNode transform(KInjectedLabel node) throws TransformerException {
        Term term = (Term)node.getTerm().accept(this);
        KInjectedLabel result = node.shallowCopy();
        result.setTerm(term);
        return this.transform((Term)result);
    }

    @Override
    public ASTNode transform(FreezerHole node) throws TransformerException {
        return this.transform((Term)node);
    }

    @Override
    public ASTNode transform(FreezerLabel node) throws TransformerException {
        Term term = (Term)node.getTerm().accept(this);
        FreezerLabel result = node.shallowCopy();
        result.setTerm(term);
        return this.transform((Term)result);
    }

    @Override
    public ASTNode transform(StringSentence node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Restrictions node) throws TransformerException {
        return node;
    }
}

