/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kompile;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FilenameUtils;
import org.kframework.backend.Backend;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.html.HtmlBackend;
import org.kframework.backend.java.symbolic.JavaSymbolicBackend;
import org.kframework.backend.kore.KoreBackend;
import org.kframework.backend.latex.LatexBackend;
import org.kframework.backend.latex.PdfBackend;
import org.kframework.backend.maude.KompileBackend;
import org.kframework.backend.symbolic.SymbolicBackend;
import org.kframework.backend.unparser.UnflattenBackend;
import org.kframework.backend.unparser.UnparserBackend;
import org.kframework.compile.utils.CompilerStepDone;
import org.kframework.compile.utils.CompilerSteps;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.CountNodesVisitor;
import org.kframework.kompile.KompileOptionsParser;
import org.kframework.krun.K;
import org.kframework.krun.Main;
import org.kframework.parser.DefinitionLoader;
import org.kframework.utils.BinaryLoader;
import org.kframework.utils.Error;
import org.kframework.utils.OptionComparator;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.file.KPaths;
import org.kframework.utils.general.GlobalSettings;

public class KompileFrontEnd {
    private static final String USAGE = "kompile [options] <file>" + System.getProperty("line.separator");
    private static final String HEADER_STANDARD = "";
    private static final String FOOTER_STANDARD = "";
    private static final String HEADER_EXPERIMENTAL = "Experimental options:";
    private static final String FOOTER_EXPERIMENTAL = Main.FOOTER_EXPERIMENTAL;

    public static void main(String[] args) throws IOException {
        KompileOptionsParser op = new KompileOptionsParser();
        CommandLine cmd = op.parse(args);
        if (cmd.hasOption("help")) {
            KompileFrontEnd.printUsageS(op);
        } else if (cmd.hasOption("help-experimental")) {
            KompileFrontEnd.printUsageE(op);
        } else if (cmd.hasOption("version")) {
            String msg = FileUtil.getFileContent(KPaths.getKBase(false) + KPaths.VERSION_FILE);
            System.out.println(msg);
        } else if (cmd.getArgs().length < 1) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "You have to provide a file in order to compile.", "command line", "System file."));
        } else {
            GlobalSettings.NOSMT |= "none".equals(cmd.getOptionValue("smt"));
            GlobalSettings.verbose |= cmd.hasOption("verbose");
            GlobalSettings.fastKast |= cmd.hasOption("fast-kast");
            GlobalSettings.noPrelude |= cmd.hasOption("no-prelude");
            GlobalSettings.warnings = cmd.getOptionValue("warnings", GlobalSettings.warnings);
            GlobalSettings.ruleIndex = cmd.getOptionValue("rule-index", GlobalSettings.ruleIndex);
            GlobalSettings.addTopCell |= cmd.hasOption("add-top-cell");
            GlobalSettings.lib = cmd.getOptionValue("lib", GlobalSettings.lib);
            GlobalSettings.synModule = cmd.getOptionValue("syntax-module", GlobalSettings.synModule);
            GlobalSettings.testgen |= cmd.hasOption("test-gen");
            K.deterministic_functions |= cmd.hasOption("deterministic-functions");
            if (cmd.hasOption("transition")) {
                GlobalSettings.transition = KompileFrontEnd.metadataParse(cmd.getOptionValue("transition"));
            }
            if (cmd.hasOption("supercool")) {
                GlobalSettings.supercool = KompileFrontEnd.metadataParse(cmd.getOptionValue("supercool"));
            }
            if (cmd.hasOption("superheat")) {
                GlobalSettings.superheat = KompileFrontEnd.metadataParse(cmd.getOptionValue("superheat"));
            }
            if (cmd.hasOption("documentation")) {
                GlobalSettings.doctags = KompileFrontEnd.metadataParse(cmd.getOptionValue("documentation"));
            }
            if (cmd.hasOption("doc-style")) {
                String style = cmd.getOptionValue("doc-style");
                GlobalSettings.style = style.startsWith("+") ? GlobalSettings.style + style.replace("+", ",") : style;
            }
            KompileFrontEnd.kompile(cmd);
        }
    }

    private static void kompile(CommandLine cmd) throws IOException {
        String backendOpt;
        K.do_kompilation = true;
        String def = cmd.getArgs()[0];
        String step = cmd.getOptionValue("step", null);
        GlobalSettings.setMainFile(def);
        GlobalSettings.outputDir = cmd.getOptionValue("directory", GlobalSettings.mainFile.getAbsoluteFile().getParent());
        Error.checkIfOutputDirectory(GlobalSettings.outputDir);
        Context context = new Context();
        if (cmd.hasOption("kcells")) {
            String kCells = cmd.getOptionValue("kcells");
            ArrayList<String> komputationCells = new ArrayList<String>();
            Collections.addAll(komputationCells, kCells.split(" "));
            context.setKomputationCells(komputationCells);
            assert (!context.getKomputationCells().isEmpty());
        }
        context.dotk = new File(GlobalSettings.outputDir + File.separator + ".k");
        context.dotk.mkdirs();
        BasicBackend backend = null;
        switch (backendOpt = cmd.getOptionValue("backend", "maude")) {
            case "pdf": {
                GlobalSettings.documentation = true;
                backend = new PdfBackend(Stopwatch.sw, context);
                break;
            }
            case "latex": {
                GlobalSettings.documentation = true;
                backend = new LatexBackend(Stopwatch.sw, context);
                break;
            }
            case "doc": {
                GlobalSettings.documentation = true;
                backend = new LatexBackend(Stopwatch.sw, context, true);
                break;
            }
            case "html": {
                if (!cmd.hasOption("doc-style")) {
                    GlobalSettings.style = "k-definition.css";
                }
                GlobalSettings.documentation = true;
                backend = new HtmlBackend(Stopwatch.sw, context);
                break;
            }
            case "kore": {
                backend = new KoreBackend(Stopwatch.sw, context);
                break;
            }
            case "maude": {
                backend = new KompileBackend(Stopwatch.sw, context);
                context.dotk = new File(GlobalSettings.outputDir + File.separator + FilenameUtils.removeExtension(GlobalSettings.mainFile.getName()) + "-kompiled");
                KompileFrontEnd.checkAnotherKompiled(context.dotk);
                context.dotk.mkdirs();
                break;
            }
            case "java": {
                GlobalSettings.javaBackend = true;
                backend = new JavaSymbolicBackend(Stopwatch.sw, context);
                context.dotk = new File(GlobalSettings.outputDir + File.separator + FilenameUtils.removeExtension(GlobalSettings.mainFile.getName()) + "-kompiled");
                KompileFrontEnd.checkAnotherKompiled(context.dotk);
                context.dotk.mkdirs();
                break;
            }
            case "unparse": {
                backend = new UnparserBackend(Stopwatch.sw, context);
                break;
            }
            case "unflatten": {
                backend = new UnparserBackend(Stopwatch.sw, context, true);
                break;
            }
            case "unflatten-java": {
                GlobalSettings.javaBackend = true;
                JavaSymbolicBackend innerBackend = new JavaSymbolicBackend(Stopwatch.sw, context);
                context.dotk = new File(GlobalSettings.outputDir + File.separator + FilenameUtils.removeExtension(GlobalSettings.mainFile.getName()) + "-kompiled");
                KompileFrontEnd.checkAnotherKompiled(context.dotk);
                context.dotk.mkdirs();
                backend = new UnflattenBackend(Stopwatch.sw, context, innerBackend);
                break;
            }
            case "symbolic": {
                GlobalSettings.symbolic = true;
                backend = new SymbolicBackend(Stopwatch.sw, context);
                context.dotk = new File(GlobalSettings.outputDir + File.separator + FilenameUtils.removeExtension(GlobalSettings.mainFile.getName()) + "-kompiled");
                KompileFrontEnd.checkAnotherKompiled(context.dotk);
                context.dotk.mkdirs();
                if (cmd.hasOption("symbolic-rules")) {
                    GlobalSettings.symbolicTags = Arrays.asList(cmd.getOptionValue("symbolic-rules").trim().split("\\s+"));
                }
                if (!cmd.hasOption("non-symbolic-rules")) break;
                GlobalSettings.nonSymbolicTags = Arrays.asList(cmd.getOptionValue("non-symbolic-rules").trim().split("\\s+"));
                break;
            }
            default: {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Invalid backend option: " + backendOpt, "", ""));
            }
        }
        if (backend != null) {
            String lang = cmd.getOptionValue("main-module", FileUtil.getMainModule(GlobalSettings.mainFile.getName()));
            if (cmd.hasOption("kore")) {
                KoreBackend koreBackend = new KoreBackend(Stopwatch.sw, context);
                koreBackend.run(DefinitionLoader.loadDefinition(GlobalSettings.mainFile, lang, backend.autoinclude(), context));
                return;
            }
            KompileFrontEnd.genericCompile(lang, backend, step, context);
        }
        KompileFrontEnd.verbose(cmd, context);
    }

    private static void verbose(CommandLine cmd, Context context) {
        Stopwatch.sw.printTotal("Total");
        if (GlobalSettings.verbose) {
            context.printStatistics();
        }
        GlobalSettings.kem.print();
        if (cmd.hasOption("loud")) {
            System.out.println("Done.");
        }
    }

    private static void genericCompile(String lang, Backend backend, String step, Context context) throws IOException {
        Stopwatch.sw.start();
        Definition javaDef = DefinitionLoader.loadDefinition(GlobalSettings.mainFile, lang, backend.autoinclude(), context);
        javaDef.accept(new CountNodesVisitor(context));
        CompilerSteps<Definition> steps = backend.getCompilationSteps();
        if (step == null) {
            step = backend.getDefaultStep();
        }
        try {
            javaDef = steps.compile(javaDef, step);
        }
        catch (CompilerStepDone e) {
            javaDef = (Definition)e.getResult();
        }
        BinaryLoader.save(context.dotk.getAbsolutePath() + "/configuration.bin", MetaK.getConfiguration(javaDef, context));
        backend.run(javaDef);
    }

    private static void printUsageS(KompileOptionsParser op) {
        Error.helpMsg(USAGE, "", "", op.getOptionsStandard(), new OptionComparator(op.getOptionList()));
    }

    private static void printUsageE(KompileOptionsParser op) {
        Error.helpMsg(USAGE, HEADER_EXPERIMENTAL, FOOTER_EXPERIMENTAL, op.getOptionsExperimental(), new OptionComparator(op.getOptionList()));
    }

    private static List<String> metadataParse(String tags) {
        String[] alltags = tags.split("\\s+");
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, alltags);
        return result;
    }

    private static void checkAnotherKompiled(File kompiled) {
        File[] kompiledList;
        for (File aKompiledList : kompiledList = kompiled.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                File f = new File(current, name);
                return f.isDirectory() && f.getAbsolutePath().endsWith("-kompiled");
            }
        })) {
            if (aKompiledList.getName().equals(kompiled.getName())) continue;
            String msg = "Creating multiple kompiled definition in the same directory is not allowed.";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, "command line", aKompiledList.getAbsolutePath()));
        }
    }
}

