/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kompile;

import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.kframework.utils.ActualPosixParser;
import org.kframework.utils.Error;

public class KompileOptionsParser {
    private final Options options;
    private final Options optionsStandard;
    private final Options optionsExperimental;
    private final ArrayList<Option> optionList = new ArrayList();

    public KompileOptionsParser() {
        this.options = new Options();
        this.optionsStandard = new Options();
        this.optionsExperimental = new Options();
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Print this help message.");
        this.addOptionS(OptionBuilder.create("h"));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("Print version information.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("verbose");
        OptionBuilder.withDescription("Verbose output.");
        this.addOptionS(OptionBuilder.create("v"));
        OptionBuilder.withLongOpt("directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("dir");
        OptionBuilder.withDescription("Path to the directory in which the output resides. An output can be either a kompiled K definition or a document which depends on the type of backend. The default is the current directory.");
        this.addOptionS(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("backend");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("backend");
        OptionBuilder.withDescription("Choose a backend. <backend> is one of [pdf|latex|html|maude|java|unparse|symbolic]. Each of [pdf|latex|html] generates a document from the given K definition. Either of [maude|java] creates the kompiled K definition. 'unparse' generates an unparsed version of the given K definition. 'symbolic' generates symbolic semantics. Experimental: 'doc' generates a .tex document, omitting rules unless specified.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("doc-style");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string/file");
        OptionBuilder.withDescription("Specify a style option for the package 'k.sty' (when '--backend [pdf|latex]' is used) or path to an alternative .css file (when '--backend html' is used).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("warnings");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("all|none");
        OptionBuilder.withDescription("Warning level. (Default: none).");
        this.addOptionS(OptionBuilder.create("w"));
        OptionBuilder.withLongOpt("main-module");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Specify main module in which a program starts to execute. This information is used by 'krun'. The default is the name of the given K definition file without the extension (.k).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("syntax-module");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Specify main module for syntax. This information is used by 'krun'. (Default: <main-module>-SYNTAX).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("superheat");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Specifies which syntactic constructs superheat the computation. To be used in combination with --supercool. <string> is a space-separated list of production tags.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("supercool");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Specifies which rules supercool the computation. To be used in combination with --superheat. <string> is a space-separated list of rule tags.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("transition");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("<string> is a space-separated list of tags designating rules to become transitions.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("help-experimental");
        OptionBuilder.withDescription("Print help on non-standard options.");
        this.addOptionS(OptionBuilder.create("X"));
        OptionBuilder.withLongOpt("step");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Name of the compilation phase after which the compilation process should stop.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("lib");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OptionBuilder.withDescription("Specify extra-libraries for compile/runtime.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("add-top-cell");
        OptionBuilder.withDescription("Add a top cell to configuration and all rules.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("kcells");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Cells which contain komputations.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("sort-cells");
        OptionBuilder.withDescription("Sort cells according to the order in the configuration.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("smt");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("solver");
        OptionBuilder.withDescription("SMT solver to use for checking constraints. <solver> is one of [z3|none]. (Default: z3). This only has an effect with '--backend symbolic'.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("fast-kast");
        OptionBuilder.withDescription("Using the (experimental) faster C SDF parser.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("no-prelude");
        OptionBuilder.withDescription("Do not include anything automatically.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("symbolic-rules");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("tags");
        OptionBuilder.withDescription("Apply symbolic transformations only to rules annotated with tags from <tags> set. This only has an effect with '--backend symbolic'.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("non-symbolic-rules");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("tags");
        OptionBuilder.withDescription("Do not apply symbolic transformations to rules annotated with tags from <tags> set. This only has an effect with '--backend symbolic'.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("test-gen");
        OptionBuilder.withDescription("Compile for test-case generation purpose in the Java backend. Use concrete sorts and automatically generated labels for heating and cooling rules. This only has an effect with '--backend java'.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("kore");
        OptionBuilder.withDescription("Generate kore files of a given k definition");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("loud");
        OptionBuilder.withDescription("Prints 'Done' at the end if all is ok.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("rule-index");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("rule-index");
        OptionBuilder.withDescription("Choose a technique for indexing the rules. <rule-index> is one of [table|path]. (Default: table). This only has effect with '--backend java'.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("deterministic-functions");
        OptionBuilder.withDescription("Throw assertion failure during execution in the java backend if function definitions are not deterministic.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("documentation");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("<string> is a space-separated list of tags designating rules to be included in the file generated with --backend=doc");
        this.addOptionE(OptionBuilder.create());
    }

    public CommandLine parse(String[] cmd) {
        ActualPosixParser parser = new ActualPosixParser();
        try {
            return parser.parse(this.options, cmd);
        }
        catch (ParseException e) {
            Error.report(e.getLocalizedMessage());
            return null;
        }
    }

    Options getOptionsStandard() {
        return this.optionsStandard;
    }

    Options getOptionsExperimental() {
        return this.optionsExperimental;
    }

    ArrayList<Option> getOptionList() {
        return this.optionList;
    }

    private void addOptionWrapper(Option opt, boolean isStandard) {
        this.options.addOption(opt);
        this.optionList.add(opt);
        if (isStandard) {
            this.optionsStandard.addOption(opt);
        } else {
            this.optionsExperimental.addOption(opt);
        }
    }

    private void addOptionS(Option opt) {
        this.addOptionWrapper(opt, true);
    }

    private void addOptionE(Option opt) {
        this.addOptionWrapper(opt, false);
    }
}

