/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun;

import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.kframework.krun.K;
import org.kframework.utils.ActualPosixParser;

public class CommandlineOptions {
    private Options options;
    private HelpFormatter help;
    private CommandLine cl;
    private Options optionsStandard;
    private Options optionsExperimental;
    private ArrayList<Option> optionList = new ArrayList();

    public CommandlineOptions() {
        this.options = new Options();
        this.help = new HelpFormatter();
        this.optionsStandard = new Options();
        this.optionsExperimental = new Options();
        if (K.debug || K.guidebug) {
            this.initializeDebugOptions();
        } else {
            this.initializeKRunOptions();
        }
    }

    private void addOptionWrapper(Option opt, boolean isStandard) {
        this.options.addOption(opt);
        this.getOptionList().add(opt);
        if (isStandard) {
            this.optionsStandard.addOption(opt);
        } else {
            this.optionsExperimental.addOption(opt);
        }
    }

    private void addOptionS(Option opt) {
        this.addOptionWrapper(opt, true);
    }

    private void addOptionE(Option opt) {
        this.addOptionWrapper(opt, false);
    }

    public void initializeKRunOptions() {
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Print this help message.");
        this.addOptionS(OptionBuilder.create("h"));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("Print version information.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("verbose");
        OptionBuilder.withDescription("Verbose output.");
        this.addOptionS(OptionBuilder.create("v"));
        OptionBuilder.withLongOpt("directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("dir");
        OptionBuilder.withDescription("Path to the directory in which the kompiled K definition resides. The default is the current directory.");
        this.addOptionS(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("main-module");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("name");
        OptionBuilder.withDescription("Specify main module in which a program starts to execute. The default is the module specified in the given compiled K definition.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("syntax-module");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("name");
        OptionBuilder.withDescription("Specify main module for syntax. The default is the module specified in the given compiled K definition.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("io");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("[on|off]");
        OptionBuilder.withDescription("Use real IO when running the definition. (Default: enabled).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("color");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("[on|off|extended]");
        OptionBuilder.withDescription("Use colors in output. (Default: on).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("terminal-color");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("color-name");
        OptionBuilder.withDescription("Background color of the terminal. Cells won't be colored in this color. (Default: black).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("parser");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("command");
        OptionBuilder.withDescription("Command used to parse programs. (Default: kast).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("config-var-parser");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OptionBuilder.withDescription("Command used to parse configuration variables. (Default: kast -e).  See --parser above. Applies to subsequent -c options until another parser is specified with this option.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("config-var");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withValueSeparator('=');
        OptionBuilder.withArgName("name=value");
        OptionBuilder.withDescription("Specify values for variables in the configuration.");
        this.addOptionS(OptionBuilder.create("c"));
        OptionBuilder.withLongOpt("output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("mode");
        OptionBuilder.withDescription("How to display Maude results. <mode> is either [pretty|smart|compatible|kore|raw|binary|none]. (Default: pretty).");
        this.addOptionS(OptionBuilder.create("o"));
        OptionBuilder.withLongOpt("search");
        OptionBuilder.withDescription("In conjunction with it you can specify 3 options that are optional: pattern (the pattern used for search), bound (the number of desired solutions) and depth (the maximum depth of the search).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("search-final");
        OptionBuilder.withDescription("Same as --search but only return final states, even if --depth is provided.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("search-all");
        OptionBuilder.withDescription("Same as --search but return all matching states, even if --depth is not provided.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("search-one-step");
        OptionBuilder.withDescription("Same as --search but search only one transition step.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("search-one-or-more-steps");
        OptionBuilder.withDescription("Same as --search-all but exclude initial state, even if it matches.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("pattern");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Specify a term and/or side condition that the result of execution or search must match in order to succeed. Return the resulting matches as a list of substitutions. In conjunction with it you can specify other 2 options that are optional: bound (the number of desired solutions) and depth (the maximum depth of the search).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("bound");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("num");
        OptionBuilder.withDescription("The number of desired solutions for search.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("depth");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("num");
        OptionBuilder.withDescription("The maximum number of computational steps to execute or search the definition for.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("graph");
        OptionBuilder.withDescription("Displays the search graph generated by the last search.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("backend");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("backend");
        OptionBuilder.withDescription("Specify the krun backend to execute with. <backend> is either [maude|java]. (Default: maude).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("simulation");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Simulation property of two programs in two semantics.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("help-experimental");
        OptionBuilder.withDescription("Print help on non-standard options.");
        this.addOptionS(OptionBuilder.create("X"));
        OptionBuilder.withLongOpt("fast-kast");
        OptionBuilder.withDescription("Using the (experimental) faster C SDF parser.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("statistics");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("[on|off]");
        OptionBuilder.withDescription("Print Maude's rewrite statistics. (Default: ...).");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("term");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Input argument will be parsed with the specified parser and used as the sole input to krun.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("maude-cmd");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("Maude command used to execute the definition.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("log-io");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("[on|off]");
        OptionBuilder.withDescription("Make the IO server create logs. (Default: disabled).");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("debug");
        OptionBuilder.withDescription("Run an execution in debug mode.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("debug-gui");
        OptionBuilder.withDescription("Run an execution in debug mode with graphical interface.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("debug-info");
        OptionBuilder.withDescription("Provide debugging information.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("trace");
        OptionBuilder.withDescription("Turn on maude trace.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("profile");
        OptionBuilder.withDescription("Turn on maude profiler.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("ltlmc");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file/string");
        OptionBuilder.withDescription("Specify the formula for model checking through a file or at commandline.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("prove");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OptionBuilder.withDescription("Prove a set of reachability rules.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("smt");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("solver");
        OptionBuilder.withDescription("SMT solver to use for checking constraints. <solver> is either [z3|gappa|none]. (Default: z3).");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("generate-tests");
        OptionBuilder.withDescription("Test programs will be generated along with normal search.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("index");
        OptionBuilder.withDescription("Index the rules for faster rewriting.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("indexing-stats");
        OptionBuilder.withDescription("Measure indexing-related information.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("deterministic-functions");
        OptionBuilder.withDescription("Throw assertion failure during execution in the java backend if function definitions are not deterministic.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("output-file");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OptionBuilder.withDescription("Store output in the file instead of displaying it.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("load-cfg");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OptionBuilder.withDescription("Load a configuration saved with the \"binary\" output mode into the $PGM configuration variable instead of a program.");
        this.addOptionE(OptionBuilder.create());
    }

    public void initializeDebugOptions() {
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Display the available commands");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("step");
        OptionBuilder.withDescription("Execute one step or multiple steps at one time if you specify a positive integer argument");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("step-all");
        OptionBuilder.withDescription("Computes all successors in one or more transitions (if you specify a positive integer argument) of the current configuration");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("select");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("number");
        OptionBuilder.withDescription("Selects the current configuration after a search result using step-all command");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("show-search-graph");
        OptionBuilder.withDescription("Displays the search graph generated by the last search");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("show-node");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("NODE");
        OptionBuilder.withDescription("Displays info about the specified node in the search graph." + K.lineSeparator + "The node is specified by its id indicated as argument of this option");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("show-edge");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withArgName("NODE1 NODE2");
        OptionBuilder.withDescription("Displays info about the specifiede edge in the search graph." + K.lineSeparator + "The edge is specified by the ids of the endpoints indicated as argument of this option");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("resume");
        OptionBuilder.withDescription("Resume the execution and exit from the debug mode");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("abort");
        OptionBuilder.withDescription("Abort the execution and exit from the debug mode");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("save");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("STRING");
        OptionBuilder.withDescription("Save the debug session to file");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("load");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("STRING");
        OptionBuilder.withDescription("Load the debug session from file");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("read");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("STRING");
        OptionBuilder.withDescription("Read a string from stdin");
        this.addOptionS(OptionBuilder.create());
    }

    public CommandLine parse(String[] cmd) {
        ActualPosixParser parser = new ActualPosixParser();
        try {
            this.setCommandLine(parser.parse(this.options, cmd));
            return this.getCommandLine();
        }
        catch (ParseException e) {
            System.out.println("Error while parsing commandline:" + e.getMessage());
            return null;
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public HelpFormatter getHelp() {
        return this.help;
    }

    CommandLine getCommandLine() {
        return this.cl;
    }

    void setCommandLine(CommandLine cl) {
        this.cl = cl;
    }

    public Options getOptionsStandard() {
        return this.optionsStandard;
    }

    public Options getOptionsExperimental() {
        return this.optionsExperimental;
    }

    public ArrayList<Option> getOptionList() {
        return this.optionList;
    }

    public void setOptionList(ArrayList<Option> optionList) {
        this.optionList = optionList;
    }
}

