/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.kframework.compile.transformers.AddEmptyLists;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Bag;
import org.kframework.kil.Cell;
import org.kframework.kil.Freezer;
import org.kframework.kil.FreezerLabel;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.Production;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Token;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.parser.concrete.disambiguate.TypeSystemFilter;

public class ConcretizeSyntax
extends CopyOnWriteTransformer {
    public ConcretizeSyntax(Context context) {
        super("Abstract K to Syntax K", context);
    }

    @Override
    public ASTNode transform(KApp kapp) throws TransformerException {
        ASTNode t = this.internalTransform(kapp);
        try {
            t = t.accept(new TypeSystemFilter(this.context));
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        t = t.accept(new RemoveEmptyLists(this.context));
        return t;
    }

    public ASTNode internalTransform(KApp kapp) throws TransformerException {
        Term label = kapp.getLabel();
        Term child = kapp.getChild();
        child = child.shallowCopy();
        if (label instanceof KInjectedLabel && child.equals(KList.EMPTY)) {
            if (label instanceof FreezerLabel) {
                FreezerLabel l = (FreezerLabel)label;
                return new Freezer((Term)l.getTerm().accept(this));
            }
            Term injected = ((KInjectedLabel)label).getTerm();
            return (Term)injected.accept(this);
        }
        if (label instanceof KLabelConstant) {
            String klabel = ((KLabelConstant)label).getLabel();
            Set<String> conses = this.context.labels.get(klabel);
            List<Object> contents = new ArrayList();
            ArrayList<Term> possibleTerms = new ArrayList<Term>();
            if (child instanceof KList) {
                contents = ((KList)child).getContents();
            }
            if (conses != null) {
                for (int i = 0; i < contents.size(); ++i) {
                    contents.set(i, (Term)((Term)contents.get(i)).accept(this));
                }
                for (String cons : conses) {
                    Production p = (Production)this.context.conses.get(cons);
                    ArrayList<Object> newContents = new ArrayList<Object>(contents);
                    if (p.getAttribute("reject") != null || p.getArity() != contents.size()) continue;
                    for (int i = 0; i < contents.size(); ++i) {
                        if (contents.get(i) instanceof KApp && ((KApp)contents.get(i)).getLabel() instanceof KInjectedLabel) {
                            KInjectedLabel l = (KInjectedLabel)((KApp)contents.get(i)).getLabel();
                            if (!this.context.isSubsortedEq(p.getChildSort(i), l.getTerm().getSort())) continue;
                            newContents.set(i, l.getTerm());
                            continue;
                        }
                        newContents.set(i, ((Term)newContents.get(i)).shallowCopy());
                    }
                    possibleTerms.add(new TermCons(p.getSort(), cons, newContents, this.context));
                }
                if (possibleTerms.size() == 0) {
                    return super.transform(kapp);
                }
                if (possibleTerms.size() == 1) {
                    return (ASTNode)possibleTerms.get(0);
                }
                return new Ambiguity("K", possibleTerms);
            }
            if (child.equals(KList.EMPTY)) {
                Set<String> sorts = this.context.listLabels.get(klabel);
                possibleTerms = new ArrayList();
                if (sorts != null) {
                    for (String sort : sorts) {
                        possibleTerms.add(new ListTerminator(sort, null));
                    }
                    if (possibleTerms.size() == 0) {
                        return super.transform(kapp);
                    }
                    if (possibleTerms.size() == 1) {
                        return (ASTNode)possibleTerms.get(0);
                    }
                    return new Ambiguity("K", possibleTerms);
                }
            }
        } else if (label instanceof Token) {
            assert (child instanceof KList);
            assert (((KList)child).getContents().size() == 0);
            return kapp;
        }
        return super.transform(kapp);
    }

    @Override
    public ASTNode transform(Cell cell) throws TransformerException {
        if (cell.getLabel().matches(".*-fragment")) {
            return cell.getContents().accept(this);
        }
        return super.transform(cell);
    }

    @Override
    public ASTNode transform(Bag bag) throws TransformerException {
        ArrayList<Term> contents = new ArrayList<Term>();
        for (Term child : bag.getContents()) {
            Term accept = (Term)child.accept(this);
            if (accept instanceof ListTerminator) {
                ListTerminator empty = (ListTerminator)accept;
                if (empty.getSort().equals("Bag")) continue;
                contents.add(accept);
                continue;
            }
            contents.add(accept);
        }
        if (contents.size() == 0) {
            return new ListTerminator("Bag", null);
        }
        if (contents.size() == 1) {
            return (ASTNode)contents.get(0);
        }
        return new Bag(contents);
    }

    public static class RemoveEmptyLists
    extends CopyOnWriteTransformer {
        public RemoveEmptyLists(Context context) {
            super("Reverse AddEmptyLists", context);
        }

        @Override
        public ASTNode transform(TermCons tcParent) throws TransformerException {
            for (int i = 0; i < tcParent.getContents().size(); ++i) {
                Term child = tcParent.getContents().get(i);
                this.internalTransform(tcParent, i, child);
            }
            return tcParent;
        }

        private void internalTransform(TermCons tcParent, int i, Term child) {
            if (child instanceof TermCons) {
                TermCons termCons = (TermCons)child;
                if (termCons.getProduction().isListDecl() && new AddEmptyLists(this.context).isAddEmptyList(tcParent.getProduction().getChildSort(i), termCons.getContents().get(0).getSort()) && termCons.getContents().get(1) instanceof ListTerminator) {
                    tcParent.getContents().set(i, termCons.getContents().get(0));
                }
            } else if (child instanceof Ambiguity) {
                Ambiguity amb = (Ambiguity)child;
                for (Term choice : amb.getContents()) {
                    this.internalTransform(tcParent, i, choice);
                }
            }
        }
    }
}

