/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.kframework.kil.BackendTerm;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.K;
import org.kframework.parser.ProgramLoader;
import org.kframework.utils.Error;
import org.kframework.utils.ThreadedStreamCapturer;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.general.GlobalSettings;

public class RunProcess {
    private String stdout = null;
    private String err = null;
    private int exitCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, String> environment, String ... commands) {
        try {
            String s2;
            if (commands.length <= 0) {
                Error.report("Need command options to run");
            }
            ProcessBuilder pb = new ProcessBuilder(commands);
            Map<String, String> realEnvironment = pb.environment();
            realEnvironment.putAll(environment);
            pb.directory(new File(K.userdir));
            Process process = pb.start();
            InputStream inputStream = process.getInputStream();
            InputStream errorStream = process.getErrorStream();
            ThreadedStreamCapturer inputStreamHandler = new ThreadedStreamCapturer(inputStream);
            ThreadedStreamCapturer errorStreamHandler = new ThreadedStreamCapturer(errorStream);
            inputStreamHandler.start();
            errorStreamHandler.start();
            process.waitFor();
            this.setExitCode(process.exitValue());
            ThreadedStreamCapturer threadedStreamCapturer = inputStreamHandler;
            synchronized (threadedStreamCapturer) {
                while (inputStreamHandler.isAlive()) {
                    inputStreamHandler.wait();
                }
            }
            threadedStreamCapturer = errorStreamHandler;
            synchronized (threadedStreamCapturer) {
                while (errorStreamHandler.isAlive()) {
                    errorStreamHandler.wait();
                }
            }
            String s1 = inputStreamHandler.getContent().toString();
            if (!s1.equals("")) {
                this.setStdout(s1);
            }
            if (!(s2 = errorStreamHandler.getContent().toString()).equals("")) {
                this.setErr(s2);
            }
        }
        catch (IOException e) {
            Error.report("Error while running process:" + e.getMessage());
        }
        catch (InterruptedException e) {
            Error.report("Error while running process:" + e.getMessage());
        }
    }

    public Term runParserOrDie(String parser, String pgm, boolean isPgm, String startSymbol, Context context) throws IOException {
        try {
            return this.runParser(parser, pgm, isPgm, startSymbol, context);
        }
        catch (TransformerException e) {
            e.report();
            return null;
        }
    }

    public Term runParser(String parser, String value, boolean isNotFile, String startSymbol, Context context) throws TransformerException {
        Term term;
        if (startSymbol == null) {
            startSymbol = context.startSymbolPgm;
        }
        String content = value;
        switch (parser) {
            case "kast": {
                if (!isNotFile) {
                    content = FileUtil.getFileContent(value);
                }
                term = ProgramLoader.processPgm(content, value, K.definition, startSymbol, context, GlobalSettings.ParserType.PROGRAM);
                break;
            }
            case "kast -e": {
                term = ProgramLoader.processPgm(value, value, K.definition, startSymbol, context, GlobalSettings.ParserType.PROGRAM);
                break;
            }
            case "kast -groundParser": {
                if (!isNotFile) {
                    content = FileUtil.getFileContent(value);
                }
                term = ProgramLoader.processPgm(content, value, K.definition, startSymbol, context, GlobalSettings.ParserType.GROUND);
                break;
            }
            case "kast -groundParser -e": {
                term = ProgramLoader.processPgm(value, value, K.definition, startSymbol, context, GlobalSettings.ParserType.GROUND);
                break;
            }
            case "kast -ruleParser": {
                if (!isNotFile) {
                    content = FileUtil.getFileContent(value);
                }
                term = ProgramLoader.processPgm(content, value, K.definition, startSymbol, context, GlobalSettings.ParserType.RULES);
                break;
            }
            default: {
                ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(parser.split(" ")));
                tokens.add(value);
                HashMap<String, String> environment = new HashMap<String, String>();
                environment.put("KRUN_SORT", startSymbol);
                environment.put("KRUN_COMPILED_DEF", context.kompiled.getAbsolutePath());
                if (isNotFile) {
                    environment.put("KRUN_IS_NOT_FILE", "true");
                }
                this.execute(environment, tokens.toArray(new String[tokens.size()]));
                if (this.getExitCode() != 0) {
                    throw new TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Parser returned a non-zero exit code: " + this.getExitCode() + "\nStdout:\n" + this.getStdout() + "\nStderr:\n" + this.getErr()));
                }
                String kast = this.getStdout() != null ? this.getStdout() : "";
                term = new BackendTerm("", kast);
            }
        }
        return term;
    }

    public void printError(String content, String lang, Context context) {
        try {
            if (content.contains("GLIBC")) {
                System.out.println("\nError: A known bug in the current version of the Maude rewrite engine\nprohibits running K with I/O on certain architectures.\nIf non I/O programs and definitions work but I/O ones fail, \nplease let us know and we'll try helping you fix it.\n");
                return;
            }
            System.out.println("Krun was executed with the following arguments:" + K.lineSeparator + "syntax_module=" + K.syntax_module + K.lineSeparator + "main_module=" + K.main_module + K.lineSeparator + "compiled_def=" + K.compiled_def + K.lineSeparator);
            String compiledDefName = context.kompiled.getName();
            int index = compiledDefName.indexOf("-kompiled");
            compiledDefName = compiledDefName.substring(0, index);
            if (lang != null && !lang.equals(compiledDefName)) {
                Error.silentReport("Compiled definition file name (" + compiledDefName + ") and the extension of the program (" + lang + ") aren't the same. " + "Maybe you should use --syntax-module or --main-module options of krun");
            }
            String fileName = new File(K.maude_err).getName();
            String fullPath = new File(K.kdir + K.fileSeparator + "krun" + K.fileSeparator + fileName).getCanonicalPath();
            Error.silentReport("Maude produced warnings or errors.\n" + content);
        }
        catch (IOException e) {
            Error.report("Error in checkMaudeForErrors method:" + e.getMessage());
        }
    }

    public String getStdout() {
        return this.stdout;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public String getErr() {
        return this.err;
    }

    public void setErr(String err) {
        this.err = err;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

