/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.kframework.krun.K;
import org.kframework.utils.Error;
import org.kframework.utils.file.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document readXMLFromFile(String fileName) {
        try (BufferedInputStream byteStream = new BufferedInputStream(new FileInputStream(fileName));){
            Document document = XmlUtil.readXML(new InputSource(byteStream));
            return document;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document readXMLFromString(String s) {
        try (StringReader reader = new StringReader(s);){
            Document document = XmlUtil.readXML(new InputSource(reader));
            return document;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document readXML(InputSource input) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.parse(input);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            Error.report("Error while reading XML:" + e.getMessage());
        }
        return doc;
    }

    public static ArrayList<Element> getChildElements(Node node) {
        ArrayList<Element> l = new ArrayList<Element>();
        Node childNode = node.getFirstChild();
        while (childNode != null) {
            Node nextChild;
            if (childNode.getNodeType() == 1) {
                Element elem = (Element)childNode;
                l.add(elem);
            }
            childNode = nextChild = childNode.getNextSibling();
        }
        return l;
    }

    public static void serializeXML(Node doc, String fileName) {
        DOMSource xmlSource = new DOMSource(doc);
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(fileName));){
            StreamResult result = new StreamResult(outStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
            transformer.transform(xmlSource, result);
        }
        catch (TransformerFactoryConfigurationError factoryError) {
            Error.report("Error creating TransformerFactory:" + factoryError.getMessage());
        }
        catch (TransformerException transformerError) {
            Error.report("Error transforming document:" + transformerError.getMessage());
        }
        catch (IOException ioException) {
            Error.report("Error while serialize XML:" + ioException.getMessage());
        }
    }

    public static String process(Element node) {
        int i;
        StringBuilder sb = new StringBuilder();
        String op = node.getAttribute("op");
        String sort = node.getAttribute("sort");
        ArrayList<Element> list = XmlUtil.getChildElements(node);
        if (sort.equals("#NzNat") && op.equals("sNat_")) {
            sb = new StringBuilder();
            sb.append(node.getAttribute("number"));
            return sb.toString();
        }
        int n = list.size();
        if (n == 0) {
            sb = new StringBuilder();
            sb.append("(");
            sb.append(op);
            sb.append(")." + sort);
            return sb.toString();
        }
        ArrayList<String> elements = new ArrayList<String>();
        for (i = 0; i < list.size(); ++i) {
            Element child = list.get(i);
            String elem = XmlUtil.process(child);
            elements.add(elem);
        }
        sb = new StringBuilder(op);
        sb.append("(");
        for (i = 0; i < elements.size(); ++i) {
            sb.append((String)elements.get(i));
            if (i == elements.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static Element getTerm(Document doc, String tagName, String attributeName, String xpathExpression, String solutionIdentifier) {
        Element result = null;
        NodeList list = doc.getElementsByTagName(tagName);
        if (list.getLength() == 0) {
            Error.silentReport("The node with " + tagName + "tag wasn't found. Make sure that you applied a" + K.lineSeparator + "search before using select command");
            return result;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            String solIdentifier;
            Element elem;
            Node nod = list.item(i);
            if (nod == null) {
                Error.report("The node with " + tagName + " tag wasn't found");
                continue;
            }
            if (nod.getNodeType() != 1 || (elem = (Element)nod).getAttribute(attributeName).equals("NONE") || !(solIdentifier = elem.getAttribute(attributeName)).equals(solutionIdentifier)) continue;
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            String s = xpathExpression;
            try {
                Object result1 = xpath.evaluate(s, nod, XPathConstants.NODESET);
                if (result1 != null) {
                    NodeList nodes = (NodeList)result1;
                    nod = nodes.item(0);
                    result = (Element)nod;
                    break;
                }
                String output = FileUtil.getFileContent(K.maude_out);
                Error.report("Unable to parse Maude's search results:\n" + output);
                continue;
            }
            catch (XPathExpressionException e) {
                Error.report("XPathExpressionException " + e.getMessage());
            }
        }
        return result;
    }
}

