/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.api;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Map;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.compile.utils.RuleCompilerSteps;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.K;
import org.kframework.krun.KRunExecutionException;
import org.kframework.krun.api.KRun;
import org.kframework.krun.api.KRunDebugger;
import org.kframework.krun.api.KRunState;
import org.kframework.krun.api.SearchResults;
import org.kframework.krun.api.SearchType;
import org.kframework.krun.api.SemanticEqual;
import org.kframework.krun.api.Transition;
import org.kframework.parser.DefinitionLoader;
import org.kframework.parser.concrete.KParser;
import org.kframework.parser.concrete.disambiguate.CollectVariablesVisitor;

public class KRunApiDebugger
implements KRunDebugger {
    private KRun krun;
    private Integer currentState;
    private DirectedGraph<KRunState, Transition> graph;
    private BidiMap<Integer, KRunState> states;
    private static Rule defaultPattern;
    private static RuleCompilerSteps defaultPatternInfo;
    protected Context context;

    public KRunApiDebugger(KRun krun, Term cfg, Context context) throws KRunExecutionException {
        this.context = context;
        try {
            KParser.ImportTbl(K.compiled_def + "/def/Concrete.tbl");
            ASTNode pattern = DefinitionLoader.parsePattern(K.pattern, "Command line pattern", "Bag", context);
            CollectVariablesVisitor vars = new CollectVariablesVisitor(context);
            pattern.accept(vars);
            defaultPatternInfo = new RuleCompilerSteps(K.definition, context);
            pattern = defaultPatternInfo.compile(new Rule((Sentence)pattern), (String)null);
            defaultPattern = (Rule)pattern;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.krun = krun;
        KRunState initialState = new KRunState(cfg, K.stateCounter++, context);
        this.graph = new DirectedSparseGraph<KRunState, Transition>();
        this.graph.addVertex(initialState);
        this.states = new DualHashBidiMap<Integer, KRunState>();
        this.putState(initialState);
        KRunState reduced = krun.step(cfg, 0).getResult();
        reduced.setStateId(K.stateCounter++);
        if (this.putState(reduced)) {
            this.graph.addVertex(reduced);
            this.graph.addEdge(Transition.reduce(context), initialState, reduced);
            this.currentState = reduced.getStateId();
        } else {
            this.currentState = initialState.getStateId();
        }
    }

    public KRunApiDebugger(KRun krun, DirectedGraph<KRunState, Transition> graph) {
        this.krun = krun;
        this.currentState = null;
        this.graph = graph;
        this.states = new DualHashBidiMap<Integer, KRunState>();
        for (KRunState state : graph.getVertices()) {
            this.putState(state);
        }
    }

    private boolean putState(KRunState state) {
        if (!this.states.containsValue(state)) {
            this.states.put(state.getStateId(), state);
            return true;
        }
        return false;
    }

    @Override
    public DirectedGraph<KRunState, Transition> getGraph() {
        return this.graph;
    }

    @Override
    public Integer getCurrentState() {
        return this.currentState;
    }

    @Override
    public void setCurrentState(Integer stateNum) throws IllegalArgumentException {
        if (stateNum != null && !this.states.containsKey(stateNum)) {
            throw new IllegalArgumentException("Must set current state to a state number already in the graph.");
        }
        this.currentState = stateNum;
    }

    @Override
    public KRunState getState(int stateNum) {
        KRunState state = (KRunState)this.states.get(stateNum);
        if (state == null) {
            throw new IllegalArgumentException("Selected state does not exist in the graph.");
        }
        return state;
    }

    private void steppingLoop(Integer steps) throws Exception {
        if (this.currentState == null) {
            throw new IllegalStateException("Cannot step without a current state to step from.");
        }
        for (int i = 0; steps == null || i < steps; ++i) {
            KRunState nextStep = this.krun.step(this.getState(this.currentState).getRawResult(), 1).getResult();
            Map.Entry<Integer, KRunState> prevValue = this.containsValue(nextStep);
            if (prevValue != null) {
                nextStep = prevValue.getValue();
                int stateId = prevValue.getKey();
                if (stateId == this.currentState) {
                    return;
                }
                this.currentState = stateId;
                continue;
            }
            nextStep.setStateId(K.stateCounter++);
            this.putState(nextStep);
            this.graph.addVertex(nextStep);
            this.graph.addEdge(Transition.unlabelled(this.context), this.getState(this.currentState), nextStep);
            this.currentState = nextStep.getStateId();
        }
    }

    @Override
    public void step(int steps) throws Exception {
        this.steppingLoop(steps);
    }

    @Override
    public void resume() throws Exception {
        this.steppingLoop(null);
    }

    @Override
    public SearchResults stepAll(int steps) throws Exception {
        if (this.currentState == null) {
            throw new IllegalStateException("Cannot step without a current state to step from.");
        }
        SearchResults results = this.krun.search(null, steps, SearchType.PLUS, defaultPattern, this.getState(this.currentState).getRawResult(), defaultPatternInfo).getResult();
        this.mergeSearchGraph(results.getGraph());
        this.currentState = null;
        return results;
    }

    private void mergeSearchGraph(DirectedGraph<KRunState, Transition> graphFragment) {
        for (KRunState state : graphFragment.getVertices()) {
            Map.Entry<Integer, KRunState> prevValue = this.containsValue(state);
            if (prevValue != null) continue;
            this.putState(state);
            this.graph.addVertex(state);
        }
        for (Transition edge : graphFragment.getEdges()) {
            Pair vertices = graphFragment.getEndpoints(edge);
            Transition existingEdge = (Transition)this.graph.findEdge((KRunState)vertices.getFirst(), (KRunState)vertices.getSecond());
            KRunState first = (KRunState)vertices.getFirst();
            KRunState second = (KRunState)vertices.getSecond();
            Map.Entry<Integer, KRunState> prevValue = this.containsValue(first);
            if (prevValue != null) {
                first = prevValue.getValue();
            }
            if ((prevValue = this.containsValue(second)) != null) {
                second = prevValue.getValue();
            }
            if (existingEdge != null && existingEdge.getType() == Transition.TransitionType.UNLABELLED) {
                this.graph.removeEdge(existingEdge);
                this.graph.addEdge(edge, first, second);
                continue;
            }
            if (existingEdge != null) continue;
            this.graph.addEdge(edge, first, second);
        }
    }

    private Map.Entry<Integer, KRunState> containsValue(KRunState state) {
        for (Map.Entry<Integer, KRunState> entry : this.states.entrySet()) {
            if (!SemanticEqual.checkEquality(state.getRawResult(), ((KRunState)entry.getValue()).getRawResult())) continue;
            return entry;
        }
        return null;
    }

    private KRunState canonicalizeState(KRunState state) {
        int stateNum = this.states.getKey(state);
        return (KRunState)this.states.get(stateNum);
    }

    @Override
    public String printState(int stateNum) {
        KRunState state = this.getState(stateNum);
        UnparserFilter unparser = new UnparserFilter(true, K.color, K.parens, this.context);
        state.getResult().accept(unparser);
        return state.toString() + ":\n" + unparser.getResult();
    }

    @Override
    public Transition getEdge(int state1, int state2) {
        KRunState second;
        KRunState first = this.getState(state1);
        Transition edge = (Transition)this.graph.findEdge(first, second = this.getState(state2));
        if (edge == null) {
            throw new IllegalArgumentException("Edge between states " + state1 + " and " + state2 + " does not exist");
        }
        return edge;
    }

    @Override
    public String printEdge(int state1, int state2) {
        String rule;
        Transition edge = this.getEdge(state1, state2);
        if (edge.getType() == Transition.TransitionType.RULE) {
            UnparserFilter unparser = new UnparserFilter(true, K.color, K.parens, this.context);
            edge.getRule().accept(unparser);
            rule = unparser.getResult();
        } else {
            rule = edge.getType() == Transition.TransitionType.LABEL ? "rule [" + edge.getLabel() + "]: ..." : "rule ...";
        }
        return rule + "\n" + this.printState(state1) + "\n=>\n" + this.printState(state2);
    }

    @Override
    public void readFromStdin(String s) {
        Term result;
        if (this.currentState == null) {
            throw new IllegalStateException("Wrong command: If you previously used the step-all command you must select\nfirst a solution with the select command before executing a read from stdin.");
        }
        Term configuration = this.getState(this.currentState).getRawResult();
        AppendToStdin transformer = new AppendToStdin(s, this.context);
        try {
            result = (Term)configuration.accept(transformer);
        }
        catch (TransformerException e) {
            assert (false);
            result = null;
        }
        if (!transformer.getSucceeded()) {
            throw new IllegalStateException("Cannot perform command: Configuration does not have an stdin buffer");
        }
        KRunState newState = new KRunState(result, this.context);
        Map.Entry<Integer, KRunState> prevValue = this.containsValue(newState);
        if (prevValue != null) {
            KRunState canonicalNewState = this.canonicalizeState(newState);
            Transition edge = (Transition)this.graph.findEdge(this.getState(this.currentState), canonicalNewState);
            if (edge == null) {
                this.graph.addEdge(Transition.stdin(s, this.context), this.getState(this.currentState), canonicalNewState);
            }
            this.currentState = canonicalNewState.getStateId();
            return;
        }
        newState.setStateId(K.stateCounter++);
        this.putState(newState);
        this.graph.addVertex(newState);
        this.graph.addEdge(Transition.stdin(s, this.context), this.getState(this.currentState), newState);
        this.currentState = newState.getStateId();
    }

    private static class AppendToStdin
    extends CopyOnWriteTransformer {
        private String str;
        private boolean succeeded;
        private boolean inStdin;
        private boolean inBuffer;

        public AppendToStdin(String str, Context context) {
            super("Append a string to the stdin buffer", context);
            this.str = str;
            this.succeeded = false;
            this.inStdin = false;
            this.inBuffer = false;
        }

        public boolean getSucceeded() {
            return this.succeeded;
        }

        @Override
        public ASTNode transform(Cell cell) throws TransformerException {
            if ("stdin".equals(this.context.cells.get(cell.getLabel()).getCellAttributes().get("stream"))) {
                this.inStdin = true;
                ASTNode result = super.transform(cell);
                this.inStdin = false;
                return result;
            }
            return super.transform(cell);
        }

        @Override
        public ASTNode transform(KApp kapp) throws TransformerException {
            if (kapp.getLabel().equals(KLabelConstant.of("#buffer", this.context))) {
                this.inBuffer = true;
                ASTNode result = super.transform(kapp);
                this.inBuffer = false;
                return result;
            }
            return super.transform(kapp);
        }

        @Override
        public ASTNode transform(StringBuiltin s) throws TransformerException {
            if (this.inStdin && this.inBuffer) {
                this.succeeded = true;
                return StringBuiltin.of(s.stringValue() + this.str);
            }
            return super.transform(s);
        }
    }
}

