/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import org.kframework.backend.kore.KilTransformer;
import org.kframework.backend.symbolic.TokenVariableToSymbolic;
import org.kframework.backend.unparser.AddBracketsFilter;
import org.kframework.backend.unparser.AddBracketsFilter2;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.kil.Cell;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.ConcretizeSyntax;
import org.kframework.krun.FlattenDisambiguationFilter;
import org.kframework.krun.K;
import org.kframework.krun.SubstitutionFilter;
import org.kframework.krun.api.SemanticEqual;
import org.kframework.parser.concrete.disambiguate.TypeInferenceSupremumFilter;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class KRunState
implements Serializable {
    private Term result;
    private Term rawResult;
    private Integer stateId;
    protected Context context;

    public KRunState(Term rawResult, Context context) {
        this.context = context;
        this.rawResult = rawResult;
    }

    public static Term concretize(Term result, Context context) {
        Cell generatedTop;
        block8: {
            try {
                result = (Term)result.accept(new ConcretizeSyntax(context));
                result = (Term)result.accept(new TypeInferenceSupremumFilter(context));
                result = (Term)result.accept(new FlattenDisambiguationFilter(context));
                if (!K.parens) {
                    result = (Term)result.accept(new AddBracketsFilter(context));
                    try {
                        Term newResult;
                        final HashSet existingFreeVariables = new HashSet();
                        BasicVisitor variableCollector = new BasicVisitor(context){

                            @Override
                            public void visit(Variable var) {
                                existingFreeVariables.add(var);
                            }
                        };
                        result.accept(variableCollector);
                        AddBracketsFilter2 filter = new AddBracketsFilter2(context);
                        result = (Term)result.accept(filter);
                        HashMap<String, Term> subst = new HashMap<String, Term>(filter.substitution);
                        for (Variable var : existingFreeVariables) {
                            subst.put(var.getName(), var);
                        }
                        while (!(newResult = (Term)result.accept(new SubstitutionFilter(subst, context))).equals(result)) {
                            result = newResult;
                        }
                    }
                    catch (IOException e) {
                        GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.INTERNAL, "Could not load parser: brackets may be unsound"));
                    }
                }
                result = (Term)result.accept(new TokenVariableToSymbolic(context));
            }
            catch (TransformerException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)"Concretization threw a TransformerException");
            }
        }
        if (result.getClass() == Cell.class && (generatedTop = (Cell)result).getLabel().equals("generatedTop")) {
            result = generatedTop.getContents();
        }
        return result;
    }

    public KRunState(Term rawResult, int stateId, Context context) {
        this(rawResult, context);
        this.stateId = stateId;
    }

    public String toString() {
        if (this.stateId == null) {
            UnparserFilter unparser = new UnparserFilter(true, K.color, K.parens, this.context);
            KilTransformer trans = new KilTransformer(true, K.color, this.context);
            if (K.output_mode.equals("kore")) {
                return trans.kilToKore(this.getResult());
            }
            this.getResult().accept(unparser);
            return unparser.getResult();
        }
        return "Node " + this.stateId;
    }

    public Term getResult() {
        if (this.result == null) {
            this.result = KRunState.concretize(this.rawResult, this.context);
        }
        return this.result;
    }

    public Term getRawResult() {
        return this.rawResult;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public void setStateId(Integer stateId) {
        this.stateId = stateId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof KRunState)) {
            return false;
        }
        KRunState s = (KRunState)o;
        return SemanticEqual.checkEquality(this.rawResult, s.rawResult);
    }

    public int hashCode() {
        return this.rawResult.hashCode();
    }
}

