/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kframework.kil.BackendTerm;
import org.kframework.kil.Bag;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.CollectionItem;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Set;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.krun.api.Result;

public class SemanticEqual {
    private static boolean store;
    private static HashMap<String, String> replaceMap;
    private static ArrayList<Result> prevResults;

    public static synchronized boolean checkEquality(Term t1, Term t2) {
        for (Result r : prevResults) {
            if ((r.t1 != t1 || r.t2 != t2) && (r.t1 != t2 || r.t2 != t1)) continue;
            return r.result;
        }
        replaceMap.clear();
        boolean result = SemanticEqual.areEqual(t1, t2);
        prevResults.add(new Result(t1, t2, result));
        replaceMap.clear();
        return result;
    }

    private static boolean areEqual(Term t1, Term t2) {
        if (!SemanticEqual.checkForNull(t1, t2)) {
            return false;
        }
        if (!t1.getClass().equals(t2.getClass())) {
            return false;
        }
        if (t1 instanceof BackendTerm) {
            return ((BackendTerm)t1).getValue().length() == ((BackendTerm)t2).getValue().length();
        }
        if (t1 instanceof IntBuiltin) {
            return SemanticEqual.areEqual((IntBuiltin)t1, (IntBuiltin)t2);
        }
        if (t1 instanceof KApp) {
            return SemanticEqual.areEqual((KApp)t1, (KApp)t2);
        }
        if (t1 instanceof MapItem) {
            return SemanticEqual.areEqual((MapItem)t1, (MapItem)t2);
        }
        if (t1 instanceof CollectionItem) {
            return SemanticEqual.areEqual((CollectionItem)t1, (CollectionItem)t2);
        }
        if (t1 instanceof Collection) {
            return SemanticEqual.areEqual((Collection)t1, (Collection)t2);
        }
        if (t1 instanceof Cell) {
            return SemanticEqual.areEqual((Cell)t1, (Cell)t2);
        }
        if (t1 instanceof KInjectedLabel) {
            return SemanticEqual.areEqual((KInjectedLabel)t1, (KInjectedLabel)t2);
        }
        if (t1 instanceof TermCons) {
            return SemanticEqual.areEqual((TermCons)t1, (TermCons)t2);
        }
        return t1.equals(t2);
    }

    private static boolean areEqual(CollectionItem c1, CollectionItem c2) {
        if (!SemanticEqual.checkForNull(c1, c2)) {
            return false;
        }
        return SemanticEqual.areEqual(c1.getItem(), c2.getItem());
    }

    private static boolean areEqual(MapItem m1, MapItem m2) {
        if (!SemanticEqual.checkForNull(m1, m2)) {
            return false;
        }
        if (SemanticEqual.areEqual(m1.getKey(), m2.getKey())) {
            return SemanticEqual.areEqual(m1.getValue(), m2.getValue());
        }
        return false;
    }

    private static boolean areEqual(KApp k1, KApp k2) {
        if (!SemanticEqual.checkForNull(k1, k2)) {
            return false;
        }
        store = k1.getLabel().toString().startsWith("#sym") || store;
        boolean rez = SemanticEqual.areEqual(k1.getLabel(), k2.getLabel()) && SemanticEqual.areEqual(k1.getChild(), k2.getChild());
        store = false;
        return rez;
    }

    private static boolean areEqual(IntBuiltin i1, IntBuiltin i2) {
        if (!SemanticEqual.checkForNull(i1, i2)) {
            return false;
        }
        if (store) {
            String prevValue = replaceMap.get(i1.value());
            if (prevValue == null) {
                replaceMap.put(i1.value(), i2.value());
                return true;
            }
            boolean res = prevValue.equals(i2.value());
            return res;
        }
        return i1.value().equals(i2.value());
    }

    private static boolean isComutative(Collection c) {
        return c instanceof Bag || c instanceof Set || c instanceof Map;
    }

    private static boolean areEqual(Collection c1, Collection c2) {
        if (!SemanticEqual.checkForNull(c1, c2)) {
            return false;
        }
        if (!c1.getSort().equals(c2.getSort())) {
            return false;
        }
        if (SemanticEqual.isComutative(c1)) {
            return SemanticEqual.areMultisetsEqual(c1.getContents(), c2.getContents());
        }
        return SemanticEqual.areSetsEqual(c1.getContents(), c2.getContents());
    }

    private static boolean areEqual(Cell c1, Cell c2) {
        if (!SemanticEqual.checkForNull(c1, c2)) {
            return false;
        }
        if (!c1.getSort().equals(c2.getSort())) {
            return false;
        }
        if (!c1.getCellAttributes().equals(c2.getCellAttributes())) {
            return false;
        }
        if (!c1.getLabel().equals(c2.getLabel())) {
            return false;
        }
        return SemanticEqual.areEqual(c1.getContents(), c2.getContents()) && SemanticEqual.areMultisetsEqual(c1.getCellTerms(), c2.getCellTerms());
    }

    private static boolean areEqual(KInjectedLabel k1, KInjectedLabel k2) {
        if (!SemanticEqual.checkForNull(k1, k2)) {
            return false;
        }
        return SemanticEqual.areEqual(k1.getTerm(), k2.getTerm());
    }

    private static boolean areEqual(TermCons t1, TermCons t2) {
        if (!SemanticEqual.checkForNull(t1, t2)) {
            return false;
        }
        return SemanticEqual.areMultisetsEqual(t1.getContents(), t2.getContents());
    }

    private static boolean checkForNull(Object o1, Object o2) {
        return (o1 != null || o2 == null) && (o1 == null || o2 != null);
    }

    private static boolean areMultisetsEqual(List<Term> l1, List<Term> l2) {
        if (!SemanticEqual.checkForNull(l1, l2)) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        ArrayList<Term> clone = new ArrayList<Term>(l2);
        block0: for (Term tt1 : l1) {
            int size = clone.size();
            for (int i = 0; i < size; ++i) {
                if (!SemanticEqual.areEqual(tt1, (Term)clone.get(i))) continue;
                clone.remove(i);
                continue block0;
            }
        }
        return clone.isEmpty();
    }

    private static boolean areSetsEqual(List<Term> l1, List<Term> l2) {
        if (!SemanticEqual.checkForNull(l1, l2)) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (SemanticEqual.areEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    static {
        replaceMap = new HashMap();
        prevResults = new ArrayList();
    }
}

