/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.api;

import edu.uci.ics.jung.graph.DirectedGraph;
import java.util.List;
import java.util.Map;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.krun.K;
import org.kframework.krun.api.KRunState;
import org.kframework.krun.api.TestGenResult;
import org.kframework.krun.api.Transition;

public class TestGenResults {
    private List<TestGenResult> testGenResults;
    private DirectedGraph<KRunState, Transition> graph;
    private boolean isDefaultPattern;
    protected Context context;

    public TestGenResults(List<TestGenResult> results, DirectedGraph<KRunState, Transition> graph, boolean isDefaultPattern, Context context) {
        this.context = context;
        this.testGenResults = results;
        this.graph = graph;
        this.isDefaultPattern = isDefaultPattern;
    }

    public String toString() {
        int n = 1;
        StringBuilder sb = new StringBuilder();
        sb.append("Test generation results:");
        for (TestGenResult testGenResult : this.testGenResults) {
            sb.append("\n\nTest case " + n + ":");
            UnparserFilter t = new UnparserFilter(true, K.color, K.parens, this.context);
            Term concretePgm = KRunState.concretize(testGenResult.getGeneratedProgram(), this.context);
            concretePgm.accept(t);
            sb.append("\nProgram:\n" + t.getResult());
            sb.append("\nResult:");
            Map<String, Term> substitution = testGenResult.getSubstitution();
            if (this.isDefaultPattern) {
                UnparserFilter unparser = new UnparserFilter(true, K.color, K.parens, this.context);
                substitution.get("B:Bag").accept(unparser);
                sb.append("\n" + unparser.getResult());
            } else {
                boolean empty = true;
                for (String variable : substitution.keySet()) {
                    UnparserFilter unparser = new UnparserFilter(true, K.color, K.parens, this.context);
                    sb.append("\n" + variable + " -->");
                    substitution.get(variable).accept(unparser);
                    sb.append("\n" + unparser.getResult());
                    empty = false;
                }
                if (empty) {
                    sb.append("\nEmpty substitution");
                }
            }
            sb.append("\nConstraint:\n");
            String strCnstr = testGenResult.getConstraint().toString();
            strCnstr = strCnstr.replaceAll("'_=/=K_\\(.*?,, '\\{\\}\\(\\.KList\\)\\) =\\? Bool\\(#\"true\"\\) /\\\\ ", "");
            strCnstr = strCnstr.replaceAll(" /\\\\ '_=/=K_\\(.*?,, '\\{\\}\\(\\.KList\\)\\) =\\? Bool\\(#\"true\"\\)", "");
            strCnstr = strCnstr.replaceAll("'_=/=K_\\(.*?,, '\\{\\}\\(\\.KList\\)\\) =\\? Bool\\(#\"true\"\\)", "");
            strCnstr = strCnstr.replace("/\\ ", "/\\\n");
            sb.append(strCnstr);
            ++n;
        }
        if (n == 1) {
            sb.append("\nNo test generation results");
        }
        return sb.toString();
    }

    public DirectedGraph<KRunState, Transition> getGraph() {
        return this.graph;
    }

    public List<TestGenResult> getTestGenResults() {
        return this.testGenResults;
    }

    public boolean isDefaultPattern() {
        return this.isDefaultPattern;
    }
}

