/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.api;

import java.io.Serializable;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attributes;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.loader.Context;
import org.kframework.krun.K;

public class Transition
implements Serializable {
    private ASTNode rule;
    private String label;
    private String readString;
    private TransitionType type;
    protected Context context;

    protected Transition(Context context, TransitionType type, String label, ASTNode rule, String readString) {
        this.context = context;
        this.type = type;
        this.label = label;
        this.rule = rule;
        this.readString = readString;
    }

    public static Transition rule(ASTNode rule, Context context) {
        return new Transition(context, TransitionType.RULE, null, rule, null);
    }

    public static Transition label(String label, Context context) {
        return new Transition(context, TransitionType.LABEL, label, null, null);
    }

    public static Transition unlabelled(Context context) {
        return new Transition(context, TransitionType.UNLABELLED, null, null, null);
    }

    public static Transition deadlock(Context context) {
        return new Transition(context, TransitionType.DEADLOCK, null, null, null);
    }

    public static Transition reduce(Context context) {
        return new Transition(context, TransitionType.REDUCE, null, null, null);
    }

    public static Transition stdin(String readString, Context context) {
        return new Transition(context, TransitionType.STDIN, null, null, readString);
    }

    public ASTNode getRule() {
        return this.rule;
    }

    public void setRule(ASTNode rule) {
        this.rule = rule;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public TransitionType getType() {
        return this.type;
    }

    public String toString() {
        if (this.type == TransitionType.RULE) {
            Attributes a = this.rule.getAttributes();
            UnparserFilter unparser = new UnparserFilter(true, K.color, K.parens, this.context);
            a.accept(unparser);
            return "\nRule tagged " + unparser.getResult() + " ";
        }
        if (this.type == TransitionType.LABEL) {
            return "\nRule labelled " + this.label + " ";
        }
        if (this.type == TransitionType.REDUCE) {
            return "\nMaude 'reduce' command ";
        }
        if (this.type == TransitionType.UNLABELLED) {
            return "\nUnlabelled rule ";
        }
        if (this.type == TransitionType.DEADLOCK) {
            return "\nDeadlock ";
        }
        return "\nRead " + StringBuiltin.of(this.readString).value();
    }

    public static enum TransitionType {
        RULE,
        LABEL,
        UNLABELLED,
        DEADLOCK,
        REDUCE,
        STDIN;

    }
}

