/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.gui.Controller;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import org.kframework.backend.java.symbolic.JavaSymbolicKRun;
import org.kframework.backend.maude.krun.MaudeKRun;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.kil.Cell;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.ConcretizeSyntax;
import org.kframework.krun.FlattenDisambiguationFilter;
import org.kframework.krun.K;
import org.kframework.krun.KRunExecutionException;
import org.kframework.krun.Main;
import org.kframework.krun.RunProcess;
import org.kframework.krun.api.KRun;
import org.kframework.krun.api.KRunDebugger;
import org.kframework.krun.api.KRunState;
import org.kframework.krun.api.SearchResults;
import org.kframework.krun.api.Transition;
import org.kframework.parser.concrete.disambiguate.BestFitFilter;
import org.kframework.parser.concrete.disambiguate.GetFitnessUnitTypeCheckVisitor;
import org.kframework.parser.concrete.disambiguate.TypeInferenceSupremumFilter;
import org.kframework.utils.Error;

public class RunKRunCommand {
    protected Term KAST;
    protected String lang;
    protected Context context;
    protected KRun krun;
    protected KRunDebugger debugger;
    protected RunProcess rp;

    public RunKRunCommand(Term kast, String lang, Context context) throws Exception {
        this.context = context;
        this.KAST = kast;
        this.lang = lang;
        this.rp = new RunProcess();
        this.krun = RunKRunCommand.createKrun(context);
        Term cfg = Main.makeConfiguration(this.KAST, null, this.rp, K.term != null, context);
        this.debugger = this.krun.debug(cfg);
    }

    public RunKRunCommand(KRunState state, String lang, Context context) throws Exception {
        this.context = context;
        this.KAST = state.getRawResult();
        this.lang = lang;
        this.rp = new RunProcess();
        this.krun = RunKRunCommand.createKrun(context);
        DirectedSparseGraph<KRunState, Transition> dg = new DirectedSparseGraph<KRunState, Transition>();
        dg.addVertex(state);
        this.debugger = this.krun.debug(dg);
    }

    public DirectedGraph<KRunState, Transition> firstStep() throws Exception {
        return this.debugger.getGraph();
    }

    public void abort() {
        System.exit(0);
    }

    public DirectedGraph<KRunState, Transition> step(KRunState v, int steps) throws Exception {
        if (steps > 0) {
            this.debugger.setCurrentState(v.getStateId());
            this.debugger.step(steps);
        }
        return this.debugger.getGraph();
    }

    public DirectedGraph<KRunState, Transition> step_all(int steps, KRunState v) throws Exception {
        if (steps < 1) {
            steps = 1;
        }
        this.debugger.setCurrentState(v.getStateId());
        SearchResults states = this.debugger.stepAll(steps);
        return this.debugger.getGraph();
    }

    public DirectedGraph<KRunState, Transition> getCurrentGraph() {
        return this.debugger.getGraph();
    }

    public String getLang() {
        return this.lang;
    }

    public KRun getKrun() {
        return this.krun;
    }

    public Context getContext() {
        return this.context;
    }

    private static KRun createKrun(Context context) {
        KRun krun;
        if (K.backend.equals("maude")) {
            krun = new MaudeKRun(context);
        } else if (K.backend.equals("java")) {
            try {
                krun = new JavaSymbolicKRun(context);
            }
            catch (KRunExecutionException e) {
                Error.report(e.getMessage());
                return null;
            }
        } else {
            Error.report("Currently supported backends are 'maude' and 'java'");
            return null;
        }
        krun.setBackendOption("io", false);
        return krun;
    }

    public static String transformTerm(Term term, Context context) {
        Cell generatedTop;
        try {
            term = (Term)term.accept(new ConcretizeSyntax(context));
            term = (Term)term.accept(new TypeInferenceSupremumFilter(context));
            term = (Term)term.accept(new BestFitFilter(new GetFitnessUnitTypeCheckVisitor(context), context));
            term = (Term)term.accept(new FlattenDisambiguationFilter(context));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        if (term.getClass() == Cell.class && (generatedTop = (Cell)term).getLabel().equals("generatedTop")) {
            term = generatedTop.getContents();
        }
        UnparserFilter unparser = new UnparserFilter(true, false, context);
        term.accept(unparser);
        return unparser.getResult();
    }
}

