/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.gui.Controller;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringEscapeUtils;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.BackendTerm;
import org.kframework.kil.Bag;
import org.kframework.kil.BagItem;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.CollectionItem;
import org.kframework.kil.Configuration;
import org.kframework.kil.Definition;
import org.kframework.kil.Freezer;
import org.kframework.kil.FreezerHole;
import org.kframework.kil.Hole;
import org.kframework.kil.Import;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.ListItem;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.LiterateDefinitionComment;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Module;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Require;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Set;
import org.kframework.kil.SetItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermComment;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.Token;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;

public class XmlUnparseFilter
extends BasicVisitor {
    private StringBuffer buffer = new StringBuffer();
    private boolean firstPriorityBlock = false;
    private boolean firstProduction = false;
    private boolean inConfiguration = false;
    private boolean addParentheses;
    private int inTerm = 0;
    private boolean forEquivalence = false;
    private List<String> variableList = new LinkedList<String>();
    private Stack<ASTNode> stack = new Stack();

    public XmlUnparseFilter(boolean inConfiguration, boolean addParentheses, Context context) {
        super(context);
        this.inConfiguration = inConfiguration;
        this.inTerm = 0;
        this.addParentheses = addParentheses;
    }

    public void setForEquivalence() {
        this.forEquivalence = true;
    }

    public String getResult() {
        return this.buffer.toString();
    }

    @Override
    public void visit(Definition def) {
        this.prepare(def);
        super.visit(def);
        this.postpare();
    }

    @Override
    public void visit(Import imp) {
        this.prepare(imp);
        if (!this.forEquivalence) {
            this.buffer.append("imports " + StringEscapeUtils.escapeXml(imp.getName()));
            this.buffer.append("\n");
        }
        this.postpare();
    }

    @Override
    public void visit(Module mod) {
        this.prepare(mod);
        if (!mod.isPredefined()) {
            if (!this.forEquivalence) {
                this.buffer.append("module " + StringEscapeUtils.escapeXml(mod.getName()));
                this.buffer.append("\n");
                this.buffer.append("\n");
            }
            super.visit(mod);
            if (!this.forEquivalence) {
                this.buffer.append("endmodule");
                this.buffer.append("\n");
                this.buffer.append("\n");
            }
        }
        this.postpare();
    }

    @Override
    public void visit(Syntax syn) {
        this.prepare(syn);
        this.firstPriorityBlock = true;
        this.buffer.append("syntax " + StringEscapeUtils.escapeXml(syn.getSort().getName()));
        if (syn.getPriorityBlocks() != null) {
            for (PriorityBlock pb : syn.getPriorityBlocks()) {
                pb.accept(this);
            }
        }
        this.buffer.append("\n");
        this.postpare();
    }

    @Override
    public void visit(PriorityBlock priorityBlock) {
        this.prepare(priorityBlock);
        if (this.firstPriorityBlock) {
            this.buffer.append(" ::=");
        } else {
            this.buffer.append(StringEscapeUtils.escapeXml("  >"));
        }
        this.firstPriorityBlock = false;
        this.firstProduction = true;
        super.visit(priorityBlock);
        this.postpare();
    }

    @Override
    public void visit(Production prod) {
        this.prepare(prod);
        if (this.firstProduction) {
            this.buffer.append(" ");
        } else {
            this.buffer.append("  | ");
        }
        this.firstProduction = false;
        for (int i = 0; i < prod.getItems().size(); ++i) {
            ProductionItem pi = prod.getItems().get(i);
            pi.accept(this);
            if (i == prod.getItems().size() - 1) continue;
            this.buffer.append(" ");
        }
        prod.getAttributes().accept(this);
        this.buffer.append("\n");
        this.postpare();
    }

    @Override
    public void visit(Sort sort) {
        this.prepare(sort);
        this.buffer.append(StringEscapeUtils.escapeXml(sort.getName()));
        super.visit(sort);
        this.postpare();
    }

    @Override
    public void visit(Terminal terminal) {
        this.prepare(terminal);
        this.buffer.append(StringEscapeUtils.escapeXml("\"" + terminal.getTerminal() + "\""));
        super.visit(terminal);
        this.postpare();
    }

    @Override
    public void visit(UserList userList) {
        this.prepare(userList);
        this.buffer.append(StringEscapeUtils.escapeXml("List{" + userList.getSort() + ",\"" + userList.getSeparator() + "\"}"));
        super.visit(userList);
        this.postpare();
    }

    @Override
    public void visit(KList listOfK) {
        this.prepare(listOfK);
        List<Term> termList = listOfK.getContents();
        for (int i = 0; i < termList.size(); ++i) {
            termList.get(i).accept(this);
            if (i == termList.size() - 1) continue;
            this.buffer.append(",, ");
        }
        if (termList.size() == 0) {
            this.buffer.append(".KList");
        }
        this.postpare();
    }

    @Override
    public void visit(Attributes attributes) {
        int i;
        this.prepare(attributes);
        LinkedList<String> reject = new LinkedList<String>();
        reject.add("cons");
        reject.add("kgeneratedlabel");
        reject.add("prefixlabel");
        reject.add("filename");
        reject.add("location");
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        List<Attribute> oldAttributeList = attributes.getContents();
        for (i = 0; i < oldAttributeList.size(); ++i) {
            if (reject.contains(oldAttributeList.get(i).getKey())) continue;
            attributeList.add(oldAttributeList.get(i));
        }
        if (!attributeList.isEmpty()) {
            this.buffer.append(" ");
            this.buffer.append("[");
            for (i = 0; i < attributeList.size(); ++i) {
                ((Attribute)attributeList.get(i)).accept(this);
                if (i == attributeList.size() - 1) continue;
                this.buffer.append(", ");
            }
            this.buffer.append("]");
        }
        this.postpare();
    }

    @Override
    public void visit(Attribute attribute) {
        this.prepare(attribute);
        this.buffer.append(StringEscapeUtils.escapeXml(attribute.getKey()));
        if (!attribute.getValue().equals("")) {
            this.buffer.append("(" + StringEscapeUtils.escapeXml(attribute.getValue()) + ")");
        }
        this.postpare();
    }

    @Override
    public void visit(Configuration configuration) {
        this.prepare(configuration);
        if (!this.forEquivalence) {
            this.buffer.append("configuration");
            this.buffer.append("\n");
            this.inConfiguration = true;
            configuration.getBody().accept(this);
            this.inConfiguration = false;
            this.buffer.append("\n");
            this.buffer.append("\n");
        }
        this.postpare();
    }

    @Override
    public void visit(Cell cell) {
        this.prepare(cell);
        String attributes = "";
        for (Map.Entry<String, String> entry : cell.getCellAttributes().entrySet()) {
            if (entry.getKey() == "ellipses") continue;
            attributes = attributes + " " + entry.getKey() + "=\"" + entry.getValue() + "\"";
        }
        String colorCode = "";
        Cell declaredCell = this.context.cells.get(cell.getLabel());
        this.buffer.append("<" + cell.getLabel() + attributes + ">");
        if (this.inConfiguration && this.inTerm == 0) {
            this.buffer.append("\n");
        } else if (cell.hasLeftEllipsis()) {
            this.buffer.append("... ");
        } else {
            this.buffer.append(" ");
        }
        cell.getContents().accept(this);
        this.buffer.append(colorCode);
        if (this.inConfiguration && this.inTerm == 0) {
            this.buffer.append("\n");
        } else if (cell.hasRightEllipsis()) {
            this.buffer.append(" ...");
        } else {
            this.buffer.append(" ");
        }
        this.buffer.append("</" + cell.getLabel() + ">");
        this.postpare();
    }

    @Override
    public void visit(Variable variable) {
        this.prepare(variable);
        if (variable.isFresh()) {
            this.buffer.append("?");
        }
        this.buffer.append(StringEscapeUtils.escapeXml(variable.getName()));
        if (!this.variableList.contains(variable.getName())) {
            this.buffer.append(":" + StringEscapeUtils.escapeXml(variable.getSort()));
            this.variableList.add(variable.getName());
        }
        this.postpare();
    }

    @Override
    public void visit(ListTerminator terminator) {
        this.prepare(terminator);
        this.buffer.append(StringEscapeUtils.escapeXml(terminator.toString()));
        this.postpare();
    }

    @Override
    public void visit(Rule rule) {
        this.prepare(rule);
        this.buffer.append("rule ");
        if (!"".equals(rule.getLabel())) {
            this.buffer.append("[" + StringEscapeUtils.escapeXml(rule.getLabel()) + "]: ");
        }
        this.variableList.clear();
        rule.getBody().accept(this);
        if (rule.getRequires() != null) {
            this.buffer.append(" when ");
            rule.getRequires().accept(this);
        }
        if (rule.getEnsures() != null) {
            this.buffer.append(" ensures ");
            rule.getEnsures().accept(this);
        }
        rule.getAttributes().accept(this);
        this.buffer.append("\n");
        this.buffer.append("\n");
        this.postpare();
    }

    @Override
    public void visit(KApp kapp) {
        this.prepare(kapp);
        Term child = kapp.getChild();
        Term label = kapp.getLabel();
        if (label instanceof Token) {
            assert (child instanceof KList) : "child of KApp with Token is not KList";
            assert (((KList)child).isEmpty()) : "child of KApp with Token is not empty";
            this.buffer.append(StringEscapeUtils.escapeXml(((Token)label).value()));
        } else {
            label.accept(this);
            this.buffer.append("(");
            child.accept(this);
            this.buffer.append(")");
        }
        this.postpare();
    }

    @Override
    public void visit(KSequence ksequence) {
        this.prepare(ksequence);
        List<Term> contents = ksequence.getContents();
        if (!contents.isEmpty()) {
            for (int i = 0; i < contents.size(); ++i) {
                contents.get(i).accept(this);
                if (i == contents.size() - 1) continue;
                this.buffer.append(StringEscapeUtils.escapeXml(" ~> "));
            }
        } else {
            this.buffer.append(".K");
        }
        this.postpare();
    }

    @Override
    public void visit(TermCons termCons) {
        this.prepare(termCons);
        ++this.inTerm;
        Production production = termCons.getProduction();
        if (production.isListDecl()) {
            UserList userList = (UserList)production.getItems().get(0);
            String separator = userList.getSeparator();
            List<Term> contents = termCons.getContents();
            contents.get(0).accept(this);
            this.buffer.append(StringEscapeUtils.escapeXml(separator) + " ");
            contents.get(1).accept(this);
        } else {
            int where = 0;
            for (int i = 0; i < production.getItems().size(); ++i) {
                ProductionItem productionItem = production.getItems().get(i);
                if (!(productionItem instanceof Terminal)) {
                    termCons.getContents().get(where++).accept(this);
                } else {
                    this.buffer.append(StringEscapeUtils.escapeXml(((Terminal)productionItem).getTerminal()));
                }
                if (i == production.getItems().size() - 1) continue;
                this.buffer.append(" ");
            }
        }
        --this.inTerm;
        this.postpare();
    }

    @Override
    public void visit(Rewrite rewrite) {
        this.prepare(rewrite);
        rewrite.getLeft().accept(this);
        this.buffer.append(StringEscapeUtils.escapeXml(" => "));
        rewrite.getRight().accept(this);
        this.postpare();
    }

    @Override
    public void visit(KLabelConstant kLabelConstant) {
        this.prepare(kLabelConstant);
        this.buffer.append(StringEscapeUtils.escapeXml(kLabelConstant.getLabel().replaceAll("`", "``").replaceAll("\\(", "`(").replaceAll("\\)", "`)")));
        this.postpare();
    }

    @Override
    public void visit(Collection collection) {
        this.prepare(collection);
        List<Term> contents = collection.getContents();
        for (int i = 0; i < contents.size(); ++i) {
            contents.get(i).accept(this);
            if (i == contents.size() - 1) continue;
            if (this.inConfiguration && this.inTerm == 0) {
                this.buffer.append("\n");
                continue;
            }
            this.buffer.append(" ");
        }
        if (contents.size() == 0) {
            this.buffer.append("." + StringEscapeUtils.escapeXml(collection.getSort()));
        }
        this.postpare();
    }

    @Override
    public void visit(CollectionItem collectionItem) {
        this.prepare(collectionItem);
        super.visit(collectionItem);
        this.postpare();
    }

    @Override
    public void visit(BagItem bagItem) {
        this.prepare(bagItem);
        this.buffer.append("BagItem(");
        super.visit(bagItem);
        this.buffer.append(")");
        this.postpare();
    }

    @Override
    public void visit(ListItem listItem) {
        this.prepare(listItem);
        this.buffer.append("ListItem(");
        super.visit(listItem);
        this.buffer.append(")");
        this.postpare();
    }

    @Override
    public void visit(SetItem setItem) {
        this.prepare(setItem);
        this.buffer.append("SetItem(");
        super.visit(setItem);
        this.buffer.append(")");
        this.postpare();
    }

    @Override
    public void visit(MapItem mapItem) {
        this.prepare(mapItem);
        mapItem.getKey().accept(this);
        this.buffer.append(StringEscapeUtils.escapeXml(" |-> "));
        mapItem.getValue().accept(this);
        this.postpare();
    }

    @Override
    public void visit(Hole hole) {
        this.buffer.append("HOLE");
        this.postpare();
    }

    @Override
    public void visit(FreezerHole hole) {
        this.prepare(hole);
        this.buffer.append("HOLE(" + hole.getIndex() + ")");
        this.postpare();
    }

    @Override
    public void visit(Freezer freezer) {
        this.prepare(freezer);
        freezer.getTerm().accept(this);
        this.postpare();
    }

    @Override
    public void visit(KInjectedLabel kInjectedLabel) {
        this.prepare(kInjectedLabel);
        Term term = kInjectedLabel.getTerm();
        if (MetaK.isKSort(term.getSort())) {
            this.buffer.append(StringEscapeUtils.escapeXml(KInjectedLabel.getInjectedSort(term.getSort())));
            this.buffer.append("2KLabel ");
        } else {
            this.buffer.append("# ");
        }
        term.accept(this);
        this.postpare();
    }

    @Override
    public void visit(KLabel kLabel) {
        this.prepare(kLabel);
        this.buffer.append("\n");
        this.buffer.append("Don't know how to pretty print KLabel");
        this.buffer.append("\n");
        super.visit(kLabel);
        this.postpare();
    }

    @Override
    public void visit(TermComment termComment) {
        this.prepare(termComment);
        this.buffer.append("<br/>");
        super.visit(termComment);
        this.postpare();
    }

    @Override
    public void visit(org.kframework.kil.List list) {
        this.prepare(list);
        super.visit(list);
        this.postpare();
    }

    @Override
    public void visit(Map map) {
        this.prepare(map);
        super.visit(map);
        this.postpare();
    }

    @Override
    public void visit(Bag bag) {
        this.prepare(bag);
        super.visit(bag);
        this.postpare();
    }

    @Override
    public void visit(Set set) {
        this.prepare(set);
        super.visit(set);
        this.postpare();
    }

    @Override
    public void visit(Ambiguity ambiguity) {
        this.prepare(ambiguity);
        this.buffer.append("amb(");
        this.buffer.append("\n");
        List<Term> contents = ambiguity.getContents();
        for (int i = 0; i < contents.size(); ++i) {
            contents.get(i).accept(this);
            if (i == contents.size() - 1) continue;
            this.buffer.append(",");
            this.buffer.append("\n");
        }
        this.buffer.append("\n");
        this.buffer.append(")");
        this.postpare();
    }

    @Override
    public void visit(org.kframework.kil.Context context) {
        this.prepare(context);
        this.buffer.append("context ");
        this.variableList.clear();
        context.getBody().accept(this);
        if (context.getRequires() != null) {
            this.buffer.append(" when ");
            context.getRequires().accept(this);
        }
        if (context.getEnsures() != null) {
            this.buffer.append(" ensures ");
            context.getEnsures().accept(this);
        }
        context.getAttributes().accept(this);
        this.buffer.append("\n");
        this.buffer.append("\n");
        this.postpare();
    }

    @Override
    public void visit(LiterateDefinitionComment literateDefinitionComment) {
        this.prepare(literateDefinitionComment);
        this.postpare();
    }

    @Override
    public void visit(Require require) {
        this.prepare(require);
        if (!this.forEquivalence) {
            this.buffer.append("require \"" + StringEscapeUtils.escapeXml(require.getValue()) + "\"");
            this.buffer.append("\n");
        }
        this.postpare();
    }

    @Override
    public void visit(BackendTerm term) {
        this.prepare(term);
        this.buffer.append(StringEscapeUtils.escapeXml(term.getValue()));
        this.postpare();
    }

    @Override
    public void visit(Bracket br) {
        this.prepare(br);
        this.buffer.append("(");
        br.getContent().accept(this);
        this.buffer.append(")");
        this.postpare();
    }

    @Override
    public void visit(Cast c) {
        this.prepare(c);
        c.getContent().accept(this);
        this.buffer.append(" :");
        if (c.isSyntactic()) {
            this.buffer.append(":");
        }
        this.buffer.append(StringEscapeUtils.escapeXml(c.getSort()));
        this.postpare();
    }

    @Override
    public void visit(Token t) {
        this.prepare(t);
        this.buffer.append(StringEscapeUtils.escapeXml("#token(\"" + t.tokenSort() + "\", \"" + t.value() + "\")"));
        this.postpare();
    }

    private void prepare(ASTNode astNode) {
        if (!this.stack.empty() && this.needsParanthesis(this.stack.peek(), astNode)) {
            this.buffer.append("(");
        }
        this.stack.push(astNode);
    }

    private void postpare() {
        ASTNode astNode = this.stack.pop();
        if (!this.stack.empty() && this.needsParanthesis(this.stack.peek(), astNode)) {
            this.buffer.append(")");
        }
    }

    private boolean needsParanthesis(ASTNode upper, ASTNode astNode) {
        if (!this.addParentheses) {
            return false;
        }
        if (astNode instanceof Rewrite) {
            return !(upper instanceof Cell) && !(upper instanceof Rule);
        }
        if (astNode instanceof TermCons && upper instanceof TermCons) {
            TermCons termConsNext = (TermCons)astNode;
            TermCons termCons = (TermCons)upper;
            Production productionNext = termConsNext.getProduction();
            Production production = termCons.getProduction();
            if (this.context.isPriorityWrong(production.getKLabel(), productionNext.getKLabel())) {
                return true;
            }
            return termConsNext.getContents().size() != 0;
        }
        return false;
    }

    public void setInConfiguration(boolean inConfiguration) {
        this.inConfiguration = inConfiguration;
    }
}

