/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.gui.UIDesign;

import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationImageServer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.subLayout.GraphCollapser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.kil.Cell;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.ConcretizeSyntax;
import org.kframework.krun.FlattenDisambiguationFilter;
import org.kframework.krun.api.KRunState;
import org.kframework.krun.api.Transition;
import org.kframework.krun.gui.Controller.RunKRunCommand;
import org.kframework.krun.gui.Controller.XmlUnparseFilter;
import org.kframework.krun.gui.UIDesign.ColorVisitor;
import org.kframework.krun.gui.UIDesign.ConfigurationPanel;
import org.kframework.krun.gui.UIDesign.MainWindow;
import org.kframework.krun.gui.UIDesign.VisualizationViewerDemo;
import org.kframework.krun.gui.UIDesign.xmlEditor.XMLEditorKit;
import org.kframework.krun.gui.diff.DiffFrame;
import org.kframework.krun.gui.helper.HelpFrame;
import org.kframework.parser.concrete.disambiguate.BestFitFilter;
import org.kframework.parser.concrete.disambiguate.GetFitnessUnitTypeCheckVisitor;
import org.kframework.parser.concrete.disambiguate.TypeInferenceSupremumFilter;

public class GraphRepresentation
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = 1017336668368978842L;
    private static final String SAVED_CONF_EXT = "sconf";
    private VisualizationViewerDemo vvd;
    private GraphZoomScrollPane gzsp;
    private GraphCollapser collapser;
    private JPanel commandControl;
    private JTabbedPane tabbedPane;
    private ConfigurationPanel nodeInfo;
    private final JTextField numberField = new JTextField(5);
    private JLabel numberOfSteps;
    private JButton step;
    private JButton stepAll;
    private JButton collapse;
    private JButton expand;
    private JButton exit;
    private JButton compare;
    private JButton help;
    private RunKRunCommand commandProcessor;
    private final ScalingControl scaler = new CrossoverScalingControl();
    private Context definitionHelper;
    private int totalSelections;
    private boolean enabled;
    private int nonKrunStateSelection;

    public GraphRepresentation(RunKRunCommand command) throws Exception {
        this.definitionHelper = command.getContext();
        this.tabbedPane = new JTabbedPane();
        this.initCommandProcessor(command);
        this.initGraph();
        this.initCollapser();
        this.initNodeInfoPanel();
        this.initCommandControlElements();
        this.addZoom();
        this.packComponents();
        this.vvd.getVv().getPickedVertexState().addItemListener(this);
        this.nonKrunStateSelection = 0;
        this.enabled = true;
        this.totalSelections = 0;
    }

    public void initCommandProcessor(RunKRunCommand command) {
        this.commandProcessor = command;
    }

    public void initGraph() throws Exception {
        DirectedGraph<KRunState, Transition> graph = null;
        try {
            graph = this.commandProcessor.firstStep();
        }
        catch (IOException e) {
            e.printStackTrace();
            MainWindow.showAndExit(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            MainWindow.showAndExit(e);
        }
        this.vvd = new VisualizationViewerDemo(graph, this);
    }

    public void initCollapser() {
        this.collapser = new GraphCollapser(this.vvd.getLayout().getGraph());
    }

    public void initNodeInfoPanel() {
        this.nodeInfo = new ConfigurationPanel();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.nodeInfo.setPreferredSize(new Dimension(screenSize.width / 3, screenSize.height));
        this.nodeInfo.setBorder(BorderFactory.createTitledBorder("Configuration"));
    }

    public void initCommandControlElements() {
        this.commandControl = new JPanel();
        this.numberOfSteps = new JLabel("Input number of steps:");
        this.help = new JButton("Help");
        this.step = new JButton("Step");
        this.stepAll = new JButton("Step-all");
        this.collapse = new JButton("Collapse");
        this.expand = new JButton("Expand");
        this.exit = new JButton("Exit");
        this.compare = new JButton("Compare");
        this.compare.setEnabled(false);
        this.addActionForHelpButton();
        this.addActionForStepButton();
        this.addActionForStepAllButton();
        this.addActionForCollapse();
        this.addActionForExpand();
        this.addActionForExit();
        this.addActionForCompare();
        this.addActionForEdit();
        this.addCommandPanelElements();
    }

    public void addZoom() {
        this.gzsp = new GraphZoomScrollPane(this.vvd.getVv());
    }

    public void packComponents() {
        this.setLayout(new BorderLayout());
        JPanel controls = new JPanel();
        controls.add(this.commandControl);
        this.add(this.gzsp);
        this.add((Component)this.tabbedPane, "East");
        this.add((Component)controls, "South");
    }

    public Context getDefinitionHelper() {
        return this.definitionHelper;
    }

    public void addActionForHelpButton() {
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpFrame helper = new HelpFrame(GraphRepresentation.this.definitionHelper);
            }
        });
    }

    public void addActionForStepButton() {
        this.step.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Class<ActionListener> clazz = ActionListener.class;
                synchronized (ActionListener.class) {
                    int oldNoOfVertices = GraphRepresentation.this.vvd.getLayout().getGraph().getVertexCount();
                    Object[] picked = GraphRepresentation.this.vvd.getSelectedVertices().toArray();
                    int noOfSteps = GraphRepresentation.this.determineNoOfSteps();
                    if (picked.length > 0) {
                        for (int i = 0; i < picked.length; ++i) {
                            if (!(picked[i] instanceof KRunState)) continue;
                            KRunState pick = (KRunState)picked[i];
                            try {
                                GraphRepresentation.this.commandProcessor.step(pick, GraphRepresentation.this.determineNoOfSteps());
                                GraphRepresentation.this.vvd.getVv().getPickedVertexState().pick(pick, false);
                                int newNoOfVertices = GraphRepresentation.this.vvd.getLayout().getGraph().getVertexCount();
                                if (newNoOfVertices != oldNoOfVertices) continue;
                                GraphRepresentation.this.selectActionStepResults(pick, 0, noOfSteps);
                                continue;
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                                continue;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        GraphRepresentation.this.redrawGraphAndResetScroll();
                    } else if (picked.length == 0) {
                        GraphRepresentation.this.showMessageOfSelectRequirement("Step");
                    }
                    GraphRepresentation.this.resetNoOfSteps();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public void selectActionStepResults(KRunState vertex, int step, int totalSteps) {
        if (step >= totalSteps) {
            return;
        }
        Object[] successors = this.vvd.getLayout().getGraph().getSuccessors(vertex).toArray();
        if (++step == totalSteps) {
            this.vvd.getVv().getPickedVertexState().pick(successors[0], true);
            return;
        }
        this.selectActionStepResults((KRunState)successors[0], step, totalSteps);
    }

    public void addActionForStepAllButton() {
        this.stepAll.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Class<ActionListener> clazz = ActionListener.class;
                synchronized (ActionListener.class) {
                    int oldNoOfVertices = GraphRepresentation.this.vvd.getLayout().getGraph().getVertexCount();
                    int noOfSteps = GraphRepresentation.this.determineNoOfSteps();
                    Object[] picked = GraphRepresentation.this.vvd.getSelectedVertices().toArray();
                    if (picked.length > 0) {
                        for (int i = 0; i < picked.length; ++i) {
                            if (!(picked[i] instanceof KRunState)) continue;
                            KRunState pick = (KRunState)picked[i];
                            try {
                                GraphRepresentation.this.commandProcessor.step_all(GraphRepresentation.this.determineNoOfSteps(), pick);
                                GraphRepresentation.this.vvd.getVv().getPickedVertexState().pick(pick, false);
                                int newNoOfVertices = GraphRepresentation.this.vvd.getLayout().getGraph().getVertexCount();
                                if (newNoOfVertices != oldNoOfVertices) continue;
                                GraphRepresentation.this.selectActionStepAllResults(pick, 0, noOfSteps);
                                continue;
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                                continue;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        GraphRepresentation.this.redrawGraphAndResetScroll();
                    } else if (picked.length == 0) {
                        GraphRepresentation.this.showMessageOfSelectRequirement("Step-all");
                    }
                    GraphRepresentation.this.resetNoOfSteps();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public void selectActionStepAllResults(KRunState vertex, int step, int totalSteps) {
        if (step >= totalSteps) {
            return;
        }
        Object[] successors = this.vvd.getLayout().getGraph().getSuccessors(vertex).toArray();
        if (++step == totalSteps) {
            for (int i = 0; i < successors.length; ++i) {
                this.vvd.getVv().getPickedVertexState().pick(successors[i], true);
            }
            return;
        }
        for (int i = 0; i < successors.length; ++i) {
            this.selectActionStepAllResults((KRunState)successors[0], step, totalSteps);
        }
    }

    public void addActionForCollapse() {
        this.collapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet picked = new HashSet(GraphRepresentation.this.vvd.getSelectedVertices());
                if (picked.size() > 1) {
                    Graph inGraph = GraphRepresentation.this.vvd.getLayout().getGraph();
                    Graph clusterGraph = GraphRepresentation.this.collapser.getClusterGraph(inGraph, picked);
                    Graph g = GraphRepresentation.this.collapser.collapse(GraphRepresentation.this.vvd.getLayout().getGraph(), clusterGraph);
                    double sumx = 0.0;
                    double sumy = 0.0;
                    for (Object v : picked) {
                        Object p = GraphRepresentation.this.vvd.getLayout().transform(v);
                        sumx += ((Point2D)p).getX();
                        sumy += ((Point2D)p).getY();
                    }
                    Point2D.Double cp = new Point2D.Double(sumx / (double)picked.size(), sumy / (double)picked.size());
                    GraphRepresentation.this.vvd.getVv().getRenderContext().getParallelEdgeIndexFunction().reset();
                    GraphRepresentation.this.vvd.getLayout().setGraph(g);
                    GraphRepresentation.this.vvd.getLayout().setLocation(clusterGraph, cp);
                    GraphRepresentation.this.vvd.getVv().getPickedVertexState().clear();
                    GraphRepresentation.this.vvd.getVv().repaint();
                }
            }
        });
    }

    public void addActionForExpand() {
        this.expand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet picked = new HashSet(GraphRepresentation.this.vvd.getVv().getPickedVertexState().getPicked());
                for (Object v : picked) {
                    if (v instanceof Graph) {
                        Graph g = GraphRepresentation.this.collapser.expand(GraphRepresentation.this.vvd.getLayout().getGraph(), (Graph)v);
                        GraphRepresentation.this.vvd.getVv().getRenderContext().getParallelEdgeIndexFunction().reset();
                        GraphRepresentation.this.vvd.getLayout().setGraph(g);
                        GraphRepresentation.this.vvd.getLayout().resetGraphPosition(g);
                    }
                    GraphRepresentation.this.vvd.getVv().getPickedVertexState().clear();
                    GraphRepresentation.this.vvd.getVv().repaint();
                }
            }
        });
    }

    public void addActionForExit() {
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
    }

    public void addActionForCompare() {
        this.compare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphRepresentation.this.vvd == null) {
                    return;
                }
                KRunState first = null;
                KRunState second = null;
                Set picked = GraphRepresentation.this.vvd.getSelectedVertices();
                if (picked == null || picked.size() != 2) {
                    GraphRepresentation.this.showMessageOfSelectRequirement("Select two configurations to compare.");
                    return;
                }
                for (KRunState krs : picked) {
                    if (first == null) {
                        first = krs;
                        continue;
                    }
                    second = krs;
                }
                GraphRepresentation.this.showCompareFrame(first, second, null);
            }
        });
    }

    public void showCompareFrame(KRunState first, KRunState second, Transition transition) {
        try {
            new DiffFrame(first, second, null, this.definitionHelper).setVisible(true);
        }
        catch (TransformerException e1) {
            this.showMessage("Unable to compare configurations due to : \n" + e1.getMessage());
        }
    }

    public void addActionForEdit() {
    }

    public int determineNoOfSteps() {
        if (this.numberField.getText().isEmpty() || Pattern.matches("[a-zA-Z]+", this.numberField.getText())) {
            return 1;
        }
        return Integer.parseInt(this.numberField.getText());
    }

    public void resetNoOfSteps() {
        this.numberField.setText("");
    }

    public void showMessageOfSelectRequirement(String method) {
        JOptionPane.showMessageDialog(new JFrame("Selection needed"), "Select a vertex for the '" + method + "' method!");
    }

    public void showMessage(String message) {
        JOptionPane.showMessageDialog(new JFrame("Attention"), message, "", 1);
    }

    public void addCommandPanelElements() {
        this.commandControl.add(this.help);
        this.commandControl.add(this.step);
        this.commandControl.add(this.stepAll);
        this.commandControl.add(this.collapse);
        this.commandControl.add(this.expand);
        this.commandControl.add(this.numberOfSteps);
        this.commandControl.add(this.numberField);
        this.commandControl.add(this.compare);
        this.commandControl.add(this.exit);
    }

    public boolean findShortestPath(Object source, Object target, String rule) {
        DijkstraShortestPath shortestPath = new DijkstraShortestPath(this.vvd.getLayout().getGraph());
        List path = shortestPath.getPath(source, target);
        if (path.size() < 1) {
            return false;
        }
        for (Transition edge : path) {
            if (!edge.getLabel().equals((Object)Transition.TransitionType.UNLABELLED) || rule.equals("")) continue;
            edge.setLabel(rule);
        }
        return true;
    }

    public void redrawGraphAndResetScroll() {
        DirectedGraph<KRunState, Transition> newGrapg = null;
        try {
            newGrapg = this.commandProcessor.getCurrentGraph();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
        Graph oldGraph = this.vvd.getLayout().getGraph();
        for (Object v : newGrapg.getVertices()) {
            if (this.vvd.verifyExistingVertex(v) != null) continue;
            oldGraph.addVertex(v);
        }
        for (Object e : newGrapg.getEdges()) {
            try {
                Object dest;
                Object source = newGrapg.getSource((Transition)e);
                if (!this.vvd.verifyCanAddEdge(source, dest = newGrapg.getDest((Transition)e))) continue;
                oldGraph.addEdge(e, source, dest);
            }
            catch (IllegalArgumentException iae) {}
        }
        this.vvd.resetGraphLayout();
        this.gzsp.revalidate();
        this.gzsp.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object item = event.getItem();
        this.scaler.scale(this.vvd.getVv(), 1.0f, (Point2D)this.vvd.getLayout().transform(item));
        this.totalSelections = event.getStateChange() == 1 ? ++this.totalSelections : --this.totalSelections;
        this.totalSelections = this.vvd.getSelectedVertices().size();
        if (!(item instanceof KRunState)) {
            if (event.getStateChange() == 1) {
                ++this.nonKrunStateSelection;
                this.changeBttnsEnableStatus(false);
            } else {
                --this.nonKrunStateSelection;
                if (this.nonKrunStateSelection == 0 && this.totalSelections > 0) {
                    this.changeBttnsEnableStatus(true);
                }
            }
        } else if (this.nonKrunStateSelection == 0 && this.totalSelections > 0) {
            this.changeBttnsEnableStatus(true);
        } else {
            this.changeBttnsEnableStatus(false);
        }
        if (this.totalSelections == 2 && this.nonKrunStateSelection == 0) {
            this.changeCompareStatus(true);
        } else {
            this.changeCompareStatus(false);
        }
        if (this.totalSelections == 1 && this.nonKrunStateSelection == 0) {
            this.changeEditStatus(true);
        } else {
            this.changeEditStatus(false);
        }
        if (this.totalSelections > 1) {
            this.changeCollapseStatus(true);
        } else {
            this.changeCollapseStatus(false);
        }
        if (this.nonKrunStateSelection == 1) {
            this.changeExpandStatus(true);
        } else {
            this.changeExpandStatus(false);
        }
        if (item instanceof KRunState) {
            KRunState sel = (KRunState)item;
            if (event.getStateChange() == 1) {
                this.addConfToTabbed(sel);
            } else {
                this.removeFromConfTabbed(sel);
            }
        }
    }

    public void removeFromConfTabbed(KRunState pick) {
        int index = -1;
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getTitleAt(i).contains(pick.getStateId() + "")) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.tabbedPane.remove(index);
        }
    }

    public void addConfToTabbed(KRunState pick) {
        ConfigurationPanel conf = new ConfigurationPanel();
        conf.init(GraphRepresentation.getXmlFromKrunState(pick, this.definitionHelper));
        XMLEditorKit.collapseMemorizedTags();
        this.tabbedPane.addTab("Config " + pick.getStateId(), conf);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
    }

    public void changeBttnsEnableStatus(boolean status) {
        if (this.enabled == status) {
            return;
        }
        this.step.setEnabled(status);
        this.stepAll.setEnabled(status);
        this.numberField.setEnabled(status);
        this.enabled = status;
    }

    public void changeCompareStatus(boolean status) {
        this.compare.setEnabled(status);
    }

    public void changeExpandStatus(boolean status) {
        this.expand.setEnabled(status);
    }

    public void changeCollapseStatus(boolean status) {
        this.collapse.setEnabled(status);
    }

    public void changeEditStatus(boolean status) {
    }

    public void savePng(String file) {
        VisualizationImageServer vis = new VisualizationImageServer(this.vvd.getVv().getGraphLayout(), this.vvd.getVv().getGraphLayout().getSize());
        vis.setBackground(Color.WHITE);
        BufferedImage image = (BufferedImage)vis.getImage(new Point2D.Double(this.vvd.getVv().getGraphLayout().getSize().getWidth() / 2.0, this.vvd.getVv().getGraphLayout().getSize().getHeight() / 2.0), new Dimension(this.vvd.getVv().getGraphLayout().getSize()));
        File outputfile = new File(file);
        try {
            ImageIO.write((RenderedImage)image, "png", outputfile);
            this.showMessage("Png saved in :" + outputfile.getCanonicalPath());
        }
        catch (IOException e) {
            try {
                this.showMessage("Unable to save png to file :" + outputfile.getCanonicalPath());
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }

    private boolean saveConf(String folder, KRunState conf) {
        File f = new File(folder + File.separator + "confSer" + conf.getStateId() + ".serConf");
        return this.saveConf(f, conf);
    }

    private boolean saveConf(File file, KRunState conf) {
        try {
            FileOutputStream outObj = new FileOutputStream(file);
            ObjectOutputStream s = new ObjectOutputStream(outObj);
            s.writeObject(conf);
            s.flush();
            s.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void saveSelectedConf() {
        Object[] picked = this.vvd.getSelectedVertices().toArray();
        if (picked.length > 0) {
            KRunState conf = (KRunState)picked[0];
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setDialogTitle("Choose where to save configuration");
            if (picked.length == 1) {
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Serialized configuration(*.sconf)", SAVED_CONF_EXT);
                chooser.setFileFilter(filter);
                chooser.setSelectedFile(new File("conf" + conf.getStateId() + "." + SAVED_CONF_EXT));
                int returnVal = chooser.showSaveDialog(this);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    File toSaveFile = !file.getName().endsWith(SAVED_CONF_EXT) ? new File(file.getParent(), file.getName() + "." + SAVED_CONF_EXT) : file;
                    if (toSaveFile.exists() && JOptionPane.showConfirmDialog(null, "Selected file already exists. Override ?", "File exists", 0) != 0) {
                        return;
                    }
                    this.saveConf(toSaveFile, conf);
                }
            } else {
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showSaveDialog(this);
                String dirPath = null;
                if (returnVal != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                dirPath = file.getAbsolutePath();
                for (int i = 0; i < picked.length; ++i) {
                    if (!(picked[i] instanceof KRunState)) continue;
                    this.saveConf(dirPath, (KRunState)picked[i]);
                }
            }
        }
    }

    private KRunState loadConf(File f) throws Exception {
        FileInputStream in = new FileInputStream(f);
        ObjectInputStream s = new ObjectInputStream(in);
        Object readObj = s.readObject();
        s.close();
        if (!(readObj instanceof KRunState)) {
            throw new Exception("Wrong config file.");
        }
        return (KRunState)readObj;
    }

    public void loadConf() {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Serialized configuration", SAVED_CONF_EXT);
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(filter);
        fc.setCurrentDirectory(new File("."));
        int returnVal = fc.showOpenDialog(this.gzsp);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                KRunState conf = this.loadConf(file);
                MainWindow.addDebugTab(new GraphRepresentation(new RunKRunCommand(conf, this.commandProcessor.getLang(), this.definitionHelper)), "Tab resulted from loading :" + file.getName());
            }
            catch (Exception e) {
                this.showMessage("Unable to load configuration from file");
            }
        }
    }

    private static String getXmlFromKrunState(KRunState pick, Context definitionHelper) {
        Cell generatedTop;
        Term term = pick.getResult();
        try {
            term = (Term)term.accept(new ConcretizeSyntax(definitionHelper));
            term = (Term)term.accept(new TypeInferenceSupremumFilter(definitionHelper));
            term = (Term)term.accept(new BestFitFilter(new GetFitnessUnitTypeCheckVisitor(definitionHelper), definitionHelper));
            term = (Term)term.accept(new FlattenDisambiguationFilter(definitionHelper));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        if (term.getClass() == Cell.class && (generatedTop = (Cell)term).getLabel().equals("generatedTop")) {
            term = generatedTop.getContents();
        }
        ColorVisitor cv = new ColorVisitor(definitionHelper);
        term.accept(cv);
        XmlUnparseFilter unparser = new XmlUnparseFilter(true, false, definitionHelper);
        term.accept(unparser);
        return unparser.getResult();
    }

    private static String getStrFromKrunState(KRunState pick, Context definitionHelper) {
        Cell generatedTop;
        Term term = pick.getResult();
        try {
            term = (Term)term.accept(new ConcretizeSyntax(definitionHelper));
            term = (Term)term.accept(new TypeInferenceSupremumFilter(definitionHelper));
            term = (Term)term.accept(new BestFitFilter(new GetFitnessUnitTypeCheckVisitor(definitionHelper), definitionHelper));
            term = (Term)term.accept(new FlattenDisambiguationFilter(definitionHelper));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        if (term.getClass() == Cell.class && (generatedTop = (Cell)term).getLabel().equals("generatedTop")) {
            term = generatedTop.getContents();
        }
        ColorVisitor cv = new ColorVisitor(definitionHelper);
        term.accept(cv);
        UnparserFilter unparser = new UnparserFilter(true, false, definitionHelper);
        term.accept(unparser);
        return unparser.getResult();
    }
}

