/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.gui.UIDesign;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.kframework.krun.gui.Controller.RunKRunCommand;
import org.kframework.krun.gui.UIDesign.ButtonTabComponent;
import org.kframework.krun.gui.UIDesign.GraphRepresentation;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 3473620040436748664L;
    private static MainWindow window;
    JTabbedPane tabbedPanel;
    JMenuBar menuBar;
    JMenu menu;

    public MainWindow(RunKRunCommand command) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(screenSize);
        this.setExtendedState(6);
        this.setDefaultCloseOperation(3);
        this.tabbedPanel = new JTabbedPane();
        try {
            this.tabbedPanel.add("Debug", new GraphRepresentation(command));
            this.getContentPane().add(this.tabbedPanel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addMenu();
        this.pack();
        this.setVisible(true);
        window = this;
    }

    private void addMenu() {
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("File");
        this.menu.setMnemonic(65);
        this.menuBar.add(this.menu);
        JMenuItem menuItem = new JMenuItem("Save configuration", 83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menuItem.getAccessibleContext().setAccessibleDescription("Save selected configuration to a file");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveConfs();
            }
        });
        this.menu.add(menuItem);
        JMenuItem menuItemLoad = new JMenuItem("Load configuration", 83);
        menuItemLoad.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        menuItemLoad.getAccessibleContext().setAccessibleDescription("Save selected configuration to a file");
        menuItemLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.loadConf();
            }
        });
        this.menu.add(menuItemLoad);
        menuItem = new JMenuItem("Export png", 80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        menuItem.getAccessibleContext().setAccessibleDescription("Saves the graph as png");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exportPng();
            }
        });
        this.menu.add(menuItem);
        this.setJMenuBar(this.menuBar);
    }

    public static void addDebugTab(GraphRepresentation newGraph, String message) {
        MainWindow.window.tabbedPanel.addTab("Loaded", null, newGraph, message);
        MainWindow.window.tabbedPanel.setTabComponentAt(MainWindow.window.tabbedPanel.getTabCount() - 1, new ButtonTabComponent(MainWindow.window.tabbedPanel));
    }

    public void exportPng() {
        Component selComp = MainWindow.window.tabbedPanel.getSelectedComponent();
        if (selComp instanceof GraphRepresentation) {
            ((GraphRepresentation)selComp).savePng("file.png");
        }
    }

    public void saveConfs() {
        Component selComp = MainWindow.window.tabbedPanel.getSelectedComponent();
        if (selComp instanceof GraphRepresentation) {
            ((GraphRepresentation)selComp).saveSelectedConf();
        }
    }

    public void loadConf() {
        Component selComp = MainWindow.window.tabbedPanel.getSelectedComponent();
        if (selComp instanceof GraphRepresentation) {
            ((GraphRepresentation)selComp).loadConf();
        }
    }

    public static void showAndExit(Exception e) {
        MainWindow.showAndExit("Exception", "Debug will close due to :\n" + e.getMessage());
    }

    public static void showAndExit(String title, String message) {
        JOptionPane.showMessageDialog(window, message, title, 0);
        window.dispose();
        System.exit(1);
    }
}

