/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.gui.UIDesign;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.GradientVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelAsShapeRenderer;
import edu.uci.ics.jung.visualization.util.PredicatedParallelEdgeIndexFunction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;
import org.kframework.krun.api.KRunState;
import org.kframework.krun.api.Transition;
import org.kframework.krun.gui.UIDesign.ClusterVertexShapeFunction;
import org.kframework.krun.gui.UIDesign.DynamicLayout;
import org.kframework.krun.gui.UIDesign.GraphRepresentation;

public class VisualizationViewerDemo {
    public static final int distanceParentChild = 100;
    public static final int distanceSameLevelNodes = 100;
    public static final int width = 400;
    public static final int heigth = 600;
    private DynamicLayout layout;
    private VisualizationViewer<KRunState, Transition> vv;
    public static ArrayList<Integer> oldIds = new ArrayList();
    private GraphRepresentation parent;

    public VisualizationViewerDemo(GraphRepresentation parent) {
        this.parent = parent;
    }

    public VisualizationViewerDemo(Graph graph, GraphRepresentation parent) {
        this.parent = parent;
        this.init(graph);
    }

    public void init(Graph<KRunState, Transition> graph) {
        this.initLayout(graph);
        this.initVisualizationViewer();
        this.setVertexProperties();
        this.setEdgeProperties();
        this.setBackgroundColor();
        this.addMouseActivity();
        this.setPredicates();
    }

    public void initLayout(Graph<KRunState, Transition> graph) {
        this.layout = new DynamicLayout<KRunState, Transition>(graph, 100, 100);
    }

    public void initVisualizationViewer() {
        Dimension preferredSize = new Dimension(400, 600);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.layout, preferredSize);
        this.vv = new VisualizationViewer(visualizationModel, preferredSize);
    }

    public void setVertexProperties() {
        VertexLabelAsShapeRenderer shapeRenderer = new VertexLabelAsShapeRenderer(this.vv.getRenderContext());
        Transformer stringer = new Transformer(){

            public String transform(Object e) {
                try {
                    Integer id = ((KRunState)e).getStateId();
                    if (!oldIds.contains(id)) {
                        oldIds.add(id);
                        if (VisualizationViewerDemo.this.getLayout().getGraph().getSuccessorCount((KRunState)e) == 0) {
                            VisualizationViewerDemo.this.vv.getPickedVertexState().pick((KRunState)e, true);
                        }
                    }
                    return "<html><center>Config<p> " + id;
                }
                catch (ClassCastException exc) {
                    String result = "Configs[";
                    result = result + VisualizationViewerDemo.this.clusteredGraphComponents("", e);
                    result = result + "]";
                    return result;
                }
            }
        };
        this.vv.getRenderContext().setVertexLabelTransformer(stringer);
        this.vv.getRenderContext().setVertexShapeTransformer(shapeRenderer);
        this.vv.getRenderContext().setVertexLabelRenderer(new DefaultVertexLabelRenderer(Color.red));
        this.vv.getRenderer().setVertexRenderer(new GradientVertexRenderer(Color.gray, Color.white, true));
        this.vv.getRenderer().setVertexLabelRenderer(shapeRenderer);
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv.getRenderContext().setVertexShapeTransformer(new ClusterVertexShapeFunction());
    }

    public String clusteredGraphComponents(String result, Object e) {
        for (Object vertex : ((DirectedSparseGraph)e).getVertices()) {
            try {
                result = result + ((KRunState)vertex).getStateId() + ", ";
            }
            catch (Exception exc) {
                result = result + this.clusteredGraphComponents("", vertex);
            }
        }
        return result;
    }

    public void setEdgeProperties() {
        Transformer<Transition, Paint> edgePaint = new Transformer<Transition, Paint>(){
            private final Color[] palette = new Color[]{Color.BLACK, Color.RED};

            @Override
            public Paint transform(Transition i) {
                Set selected = VisualizationViewerDemo.this.getSelectedEdges();
                if (selected.contains(i)) {
                    return this.palette[1];
                }
                return this.palette[0];
            }
        };
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(edgePaint);
        this.vv.getRenderContext().setEdgeStrokeTransformer(new ConstantTransformer<Stroke>(new BasicStroke(1.75f)));
        this.vv.getRenderContext().setEdgeShapeTransformer(new EdgeShape.CubicCurve());
        Transformer<Transition, String> stringer = new Transformer<Transition, String>(){

            @Override
            public String transform(Transition e) {
                return e.getLabel();
            }
        };
        this.vv.getRenderContext().setEdgeLabelTransformer(stringer);
        this.vv.getRenderContext().setLabelOffset(10);
    }

    public void setBackgroundColor() {
        this.vv.setBackground(Color.white);
    }

    public void addMouseActivity() {
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.vv.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (VisualizationViewerDemo.this.getSelectedEdges().size() == 1) {
                    for (Object edge : VisualizationViewerDemo.this.getSelectedEdges()) {
                        try {
                            KRunState dest = (KRunState)VisualizationViewerDemo.this.layout.getGraph().getDest((Transition)edge);
                            KRunState src = (KRunState)VisualizationViewerDemo.this.layout.getGraph().getSource((Transition)edge);
                            VisualizationViewerDemo.this.parent.showCompareFrame(src, dest, (Transition)edge);
                            VisualizationViewerDemo.this.resetEdgeSelection();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        });
        graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
    }

    public void resetEdgeSelection() {
        this.vv.getPickedEdgeState().clear();
    }

    public void setPredicates() {
        PredicatedParallelEdgeIndexFunction eif = PredicatedParallelEdgeIndexFunction.getInstance();
        final HashSet exclusions = new HashSet();
        eif.setPredicate(new Predicate<Transition>(){

            @Override
            public boolean evaluate(Transition e) {
                return exclusions.contains(e);
            }
        });
        this.vv.getRenderContext().setParallelEdgeIndexFunction(eif);
    }

    public DynamicLayout getLayout() {
        return this.layout;
    }

    public void setLayout(DynamicLayout layout) {
        this.layout = layout;
    }

    public VisualizationViewer getVv() {
        return this.vv;
    }

    public void setVv(VisualizationViewer vv) {
        this.vv = vv;
    }

    public Set getSelectedVertices() {
        return this.vv.getPickedVertexState().getPicked();
    }

    public Set getSelectedEdges() {
        return this.vv.getPickedEdgeState().getPicked();
    }

    public void resetGraphLayout() {
        this.layout.setGraph(this.layout.getGraph());
        this.layout.resetGraphPosition(this.layout.getGraph());
    }

    public void addEdge(KRunState source, KRunState target, int depth, String rule) {
        this.layout.getGraph().addEdge(Transition.reduce(this.parent.getDefinitionHelper()), source, target);
    }

    public Object verifyExistingVertex(Object vertex) {
        for (Object v : this.layout.getGraph().getVertices()) {
            try {
                if (!((KRunState)v).equals(vertex)) continue;
                return v;
            }
            catch (ClassCastException cce) {
                for (Object expV : ((DirectedSparseGraph)v).getVertices()) {
                    if (!((KRunState)expV).equals(vertex)) continue;
                    return v;
                }
            }
        }
        return null;
    }

    public boolean verifyCanAddEdge(Object source, Object dest) {
        for (Object vertex : this.layout.getGraph().getVertices()) {
            DirectedSparseGraph v;
            if (!(vertex instanceof DirectedSparseGraph) || !(v = (DirectedSparseGraph)vertex).containsVertex(source) || !v.containsVertex(dest)) continue;
            return false;
        }
        return true;
    }
}

